/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Recipe - Recipes from Item")
@Description(value={"Get a list of all recipes from a specific item. Due to some items having more than 1 recipe this may return multiple recipes. Requires 1.13+"})
@Examples(value={"set {_recipes::*} to all recipes of iron ingot"})
@Since(value="1.4.0")
public class ExprRecipesFromItems
extends SimpleExpression<String> {
    private Expression<ItemType> items;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        ArrayList<String> recipes = new ArrayList<String>();
        for (ItemType itemType : (ItemType[])this.items.getAll(e)) {
            ItemStack itemStack = itemType.getRandom();
            if (!$assertionsDisabled && itemStack == null) {
                throw new AssertionError();
            }
            for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)itemStack)) {
                if (!(recipe instanceof Keyed)) continue;
                recipes.add(((Keyed)recipe).getKey().toString());
            }
        }
        return recipes.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "recipes of " + this.items.toString(e, d);
    }

    static {
        boolean bl = $assertionsDisabled = !ExprRecipesFromItems.class.desiredAssertionStatus();
        if (Skript.classExists((String)"org.bukkit.Keyed")) {
            Skript.registerExpression(ExprRecipesFromItems.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] recipe[s] (for|of) %itemtypes%"});
        }
    }
}

