/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.structure.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.Structure.api.bukkit.StructureBlockLibApi;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureRestriction;

@Name(value="Structure Block - Save")
@Description(value={"Save structure block structures. 1.9.4+ ONLY"})
@Examples(value={"save structure between {loc1} and {loc2} as \"house\""})
@Since(value="1.0.0")
public class EffSaveStructure
extends Effect {
    private static final String WORLD;
    private static final StructureBlockLibApi STRUCTURE_API;
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private Expression<String> name;

    public boolean init(Expression<?> @NotNull [] exprs, int i, @NotNull Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        this.loc1 = exprs[0];
        this.loc2 = exprs[1];
        this.name = exprs[2];
        return true;
    }

    protected void execute(@NotNull Event event) {
        Location loc1 = (Location)this.loc1.getSingle(event);
        Location loc2 = (Location)this.loc2.getSingle(event);
        if (loc1 == null || loc2 == null) {
            return;
        }
        World world = loc1.getWorld();
        int x = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        Location low = new Location(world, (double)x, (double)y, (double)z);
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX()) + 1;
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY()) + 1;
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ()) + 1;
        int x3 = x2 - x;
        int y3 = y2 - y;
        int z3 = z2 - z;
        String name = (String)this.name.getSingle(event);
        STRUCTURE_API.saveStructure((Plugin)SkBee.getPlugin()).restriction(StructureRestriction.UNLIMITED).at(low).sizeX(x3).sizeY(y3).sizeZ(z3).includeEntities(true).saveToWorld(WORLD, "minecraft", name).onException(e -> {
            Skript.error((String)("Could not save structure: " + name));
            if (SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG) {
                e.printStackTrace();
            }
        });
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "save structure between " + this.loc1.toString(e, d) + " and " + this.loc2.toString(e, d) + " as " + this.name.toString(e, d);
    }

    static {
        STRUCTURE_API = StructureBlockLibApi.INSTANCE;
        String worldContainer = Bukkit.getWorldContainer().getPath();
        WORLD = worldContainer.equalsIgnoreCase(".") ? ((World)Bukkit.getServer().getWorlds().get(0)).getName() : worldContainer + File.separator + ((World)Bukkit.getServer().getWorlds().get(0)).getName();
        Skript.registerEffect(EffSaveStructure.class, (String[])new String[]{"save [structure] between %location% and %location% as %string%"});
    }
}

