/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@Name(value="Tab Completions")
@Description(value={"Set the tab completions used in a tab complete event. ", "You can specify which position in the command arguments also (will default to position 1). ", "You can also remove texts from tab completions."})
@Examples(value={"on tab complete of \"/mycommand\"", "\tset tab completions for position 1 to \"one\", \"two\" and \"three\"", "\tset tab completions for position 2 to 1, 2 and 3", "\tset tab completions for position 3 to all players", "\tset tab completions for position 4 to (indexes of {blocks::*})", "", "on tab complete:", "\tif event-string contains \"/ver\":", "\t\tremove \"PermissionsEx\" from tab completions"})
@Since(value="1.7.0")
public class ExprTabCompletion
extends SimpleExpression<String> {
    private Expression<Number> position;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(TabCompleteEvent.class)) {
            Skript.error((String)"Tab completions are only usable in a tab complete event.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.position = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(@NotNull Event event) {
        return ((TabCompleteEvent)event).getCompletions().toArray(new String[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case REMOVE: 
            case DELETE: 
            case ADD: 
            case REMOVE_ALL: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
            }
        }
        return null;
    }

    public void change(@NotNull Event e, @Nullable Object[] objects, @NotNull Changer.ChangeMode mode) {
        TabCompleteEvent event = (TabCompleteEvent)e;
        Number number = (Number)this.position.getSingle(e);
        int position = 1;
        if (number != null) {
            position = number.intValue();
        }
        switch (mode) {
            case SET: {
                String buff = event.getBuffer();
                String[] buffers = buff.split(" ");
                String last = buff.substring(buff.length() - 1);
                if ((position != buffers.length || !last.equalsIgnoreCase(" ")) && (position + 1 != buffers.length || last.equalsIgnoreCase(" "))) break;
                String arg = position == buffers.length ? "" : buffers[position];
                ArrayList<String> completions = new ArrayList<String>();
                if (objects == null) {
                    event.setCompletions(Collections.singletonList(""));
                    return;
                }
                for (Object o : objects) {
                    String object = Classes.toString((Object)o);
                    if (!StringUtil.startsWithIgnoreCase((String)object, (String)arg)) continue;
                    completions.add(object);
                }
                event.setCompletions(completions);
                break;
            }
            case REMOVE: {
                if (!$assertionsDisabled && objects == null) {
                    throw new AssertionError();
                }
                for (Object object : objects) {
                    try {
                        event.getCompletions().remove(object.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
            case ADD: {
                if (!$assertionsDisabled && objects == null) {
                    throw new AssertionError();
                }
                for (Object object : objects) {
                    try {
                        event.getCompletions().add(Classes.toString((Object)object));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
            case DELETE: {
                event.setCompletions(Collections.singletonList(""));
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String pos = this.position != null ? " for position " + this.position.toString(e, d) : "";
        return "tab completions" + pos;
    }

    static {
        boolean bl = $assertionsDisabled = !ExprTabCompletion.class.desiredAssertionStatus();
        if (Skript.classExists((String)"org.bukkit.event.server.TabCompleteEvent")) {
            Skript.registerExpression(ExprTabCompletion.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[skbee] tab completions [(of|for) position %number%]"});
        }
    }
}

