/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.board.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.elements.board.objects.Board;

@Name(value="Board - Line")
@Description(value={"set/delete a line in a player's scoreboard. Note: line 1 is bottom, line 15 is top. Accepts texts and text components (text components as of 1.5.1)."})
@Examples(value={"set line 1 of player's scoreboard to \"oooo I'm a line!!\"", "set line 15 of all players' scoreboards to \"I'm the top line!!!\"", "delete line 3 of player's scoreboard", "delete line 4 of all players' scoreboards", "", "set {_t} to translate component from player's tool", "set line 1 of player's scoreboard to {_t}"})
@Since(value="1.0.0")
public class EffBoardLine
extends Effect {
    private Expression<Number> line;
    private Expression<Player> players;
    private Expression<Object> text;
    private boolean set;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        this.line = exprs[0];
        this.players = exprs[1];
        boolean bl = this.set = matchedPattern <= 1;
        if (this.set) {
            this.text = exprs[2];
        }
        return true;
    }

    protected void execute(@NotNull Event event) {
        Player[] players = (Player[])this.players.getArray(event);
        int line = ((Number)this.line.getSingle(event)).intValue();
        if (line > 15 || line < 1) {
            return;
        }
        String text = "";
        if (this.set) {
            Object object = this.text.getSingle(event);
            text = object instanceof BaseComponent ? ((BaseComponent)object).toLegacyText() : (String)object;
        }
        for (Player player : players) {
            Board board = Board.getBoard(player);
            if (board == null) continue;
            if (this.set) {
                board.setLine(line, text);
                continue;
            }
            board.deleteLine(line);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String set = this.set ? "set" : "delete";
        String string = this.set ? " to " + this.text.toString(e, d) : "";
        return set + " line " + this.line.toString(e, d) + " of " + this.players.toString(e, d) + " scoreboard" + string;
    }

    static {
        Skript.registerEffect(EffBoardLine.class, (String[])new String[]{"set line %number% of %players%'[s] [score]board[s] to %basecomponent/string%", "set line %number% of [score]board[s] of %players% to %basecomponent/string%", "delete line %number% of %players%'[s] [score]board[s]", "delete line %number% of [score]board[s] of %players%"});
    }
}

