/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.NBT;

import ch.njol.skript.Skript;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTTileEntity;

public class NBTCustomTileEntity
extends NBTTileEntity {
    private final TileState blockState;
    private NBTCompound customNBT;
    private final boolean HAS_PERSISTENCE = Skript.isRunningMinecraft((int)1, (int)14);
    private final NamespacedKey KEY = new NamespacedKey((Plugin)SkBee.getPlugin(), "custom-nbt");

    public NBTCustomTileEntity(TileState tile) {
        super((BlockState)tile);
        this.blockState = tile;
        if (this.HAS_PERSISTENCE) {
            String data = null;
            PersistentDataContainer container = this.blockState.getPersistentDataContainer();
            if (container.has(this.KEY, PersistentDataType.STRING)) {
                data = (String)container.get(this.KEY, PersistentDataType.STRING);
            }
            this.customNBT = new NBTContainer(data != null ? data : "{}");
        }
        this.blockState.update();
    }

    public NBTCompound getCustomNBT() {
        return this.customNBT;
    }

    public void setCustomNBT(NBTCompound customNBT) {
        this.customNBT = customNBT;
        PersistentDataContainer container = this.blockState.getPersistentDataContainer();
        container.set(this.KEY, PersistentDataType.STRING, (Object)customNBT.toString());
        this.blockState.update();
    }

    public void deleteCustomNBT() {
        PersistentDataContainer container = this.blockState.getPersistentDataContainer();
        if (container.has(this.KEY, PersistentDataType.STRING)) {
            container.remove(this.KEY);
        }
        this.blockState.update();
    }

    public NBTCompound getCustomNBTCompound() {
        if (!this.HAS_PERSISTENCE) {
            return this;
        }
        NBTContainer compound = new NBTContainer(this.getCompound().toString());
        if (compound.hasKey("PublicBukkitValues").booleanValue()) {
            NBTCompound persist = compound.getCompound("PublicBukkitValues");
            persist.removeKey("skbee:custom-nbt");
            if (persist.getKeys().size() == 0) {
                compound.removeKey("PublicBukkitValues");
            }
        }
        NBTCompound customCompound = compound.addCompound("custom");
        if (this.customNBT != null) {
            customCompound.mergeCompound(this.customNBT);
        }
        return compound;
    }

    @Override
    public String toString() {
        return this.getCustomNBTCompound().toString();
    }
}

