/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.util.ChatUtil;

@Name(value="Text Component - Format")
@Description(value={"Change formatting options of text components. Most of these are pretty straight forward. Insertion means the text ", "that will copy to chat when a player shift-clicks the component (Might not be available on all versions). Color supports color ", "names as well as RGB color codes via Skript's RGB function (RGB = Minecraft 1.16+) (see examples)."})
@Examples(value={"set {_t} to text component from \"my fancy text component\"", "set bold format of {_t} to true", "set color format of {_t} to aqua", "set color format of {_t} to rgb(100, 0, 160)", "set insertion format of {_t} to \"ooooo\""})
@Since(value="1.5.1")
public class ExprComponentFormat
extends PropertyExpression<BaseComponent, Object> {
    private static final boolean HAS_SKRIPT_COLOR = Skript.classExists((String)"ch.njol.skript.util.SkriptColor");
    private static final boolean HAS_HEX = Skript.isRunningMinecraft((int)1, (int)16);
    private static final int COLOR = 0;
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int OBFUSCATED = 3;
    private static final int STRIKETHROUGH = 4;
    private static final int UNDERLINE = 5;
    private static final int INSERT = 6;
    private int pattern;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.setExpr(exprs[0]);
        return true;
    }

    protected Object @NotNull [] get(@NotNull Event e, BaseComponent @NotNull [] source) {
        return this.get(source, component -> {
            switch (this.pattern) {
                case 0: {
                    SkriptColor skriptColor = ChatUtil.getSkriptColorByBungee(component.getColor());
                    if (skriptColor != null) {
                        return skriptColor;
                    }
                    if (HAS_HEX) {
                        return ChatUtil.getColorRGBFromBungee(component.getColor());
                    }
                }
                case 1: {
                    return component.isBold();
                }
                case 2: {
                    return component.isItalic();
                }
                case 3: {
                    return component.isObfuscated();
                }
                case 4: {
                    return component.isStrikethrough();
                }
                case 5: {
                    return component.isUnderlined();
                }
                case 6: {
                    return component.getInsertion();
                }
            }
            return null;
        });
    }

    @Nullable
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(@NotNull Event e, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        Object object;
        Object object2 = object = delta != null ? delta[0] : null;
        if (object == null) {
            return;
        }
        switch (this.pattern) {
            case 0: {
                Color color = (Color)object;
                ChatColor chatColor = HAS_SKRIPT_COLOR && color instanceof SkriptColor ? ChatUtil.getBungeeFromSkriptColor((SkriptColor)color) : (HAS_HEX ? ChatUtil.getBungeeFromColor(color) : ChatColor.RESET);
                for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
                    component.setColor(chatColor);
                }
                break;
            }
            case 1: {
                for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
                    boolean bold = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setBold(Boolean.valueOf(bold));
                }
                break;
            }
            case 2: {
                for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
                    boolean italic = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setItalic(Boolean.valueOf(italic));
                }
                break;
            }
            case 3: {
                for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
                    boolean obfuscated = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setObfuscated(Boolean.valueOf(obfuscated));
                }
                break;
            }
            case 4: {
                for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
                    boolean strike = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setStrikethrough(Boolean.valueOf(strike));
                }
                break;
            }
            case 5: {
                for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
                    boolean underline = !(object instanceof Boolean) || (Boolean)object != false;
                    component.setUnderlined(Boolean.valueOf(underline));
                }
                break;
            }
            case 6: {
                for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
                    String insert = object instanceof String ? (String)object : object.toString();
                    component.setInsertion(insert);
                }
                break;
            }
        }
    }

    @NotNull
    public Class<?> getReturnType() {
        switch (this.pattern) {
            case 0: {
                return Color.class;
            }
            case 6: {
                return String.class;
            }
        }
        return Boolean.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String[] type = new String[]{"color", "bold", "italic", "obfuscated", "strikethrough", "underline", "insertion"};
        return type[this.pattern] + " format of " + this.getExpr().toString(e, d);
    }

    static {
        if (Skript.methodExists(BaseComponent.class, (String)"setInsertion", (Class[])new Class[]{String.class})) {
            ExprComponentFormat.register(ExprComponentFormat.class, Object.class, (String)"(color|1\u00a6bold|2\u00a6italic|3\u00a6(obfuscate[d]|magic)|4\u00a6strikethrough|5\u00a6underline[d]|6\u00a6insert[ion]) format", (String)"basecomponents");
        } else {
            ExprComponentFormat.register(ExprComponentFormat.class, Object.class, (String)"(color|1\u00a6bold|2\u00a6italic|3\u00a6(obfuscate[d]|magic)|4\u00a6strikethrough|5\u00a6underline[d]) format", (String)"basecomponents");
        }
    }
}

