/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.bound.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import tk.shanebee.bee.elements.bound.objects.Bound;

@Name(value="Bound - Contains Location")
@Description(value={"Check if a location is within the bounds of a bounding box."})
@Examples(value={"on break:", "\tif location of event-block is within bound with id \"spawn.bound\":", "\t\tcancel event", "", "on damage of a player:", "\tif victim is within bound {spawn}:", "\t\tcancel event"})
@Since(value="1.0.0")
public class CondBoundContainsLocation
extends Condition {
    private Expression<Bound> bound;
    private Expression<Location> locations;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.bound = exprs[1];
        this.locations = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.locations.check(event, location -> ((Bound)this.bound.getSingle(event)).isInRegion((Location)location), this.isNegated());
    }

    public String toString(Event e, boolean d) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (Event)e, (boolean)d, this.locations, (String)("in the bound " + this.bound.toString(e, d)));
    }

    static {
        PropertyCondition.register(CondBoundContainsLocation.class, (String)"[with]in [bound] %bound%", (String)"locations");
    }
}

