/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api.task;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import tk.shanebee.bee.api.virtualfurnace.api.TileManager;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.api.virtualfurnace.api.chunk.VirtualChunk;

public class TileTick
extends BukkitRunnable {
    private final VirtualFurnaceAPI virtualFurnaceAPI;
    private final TileManager tileManager;
    private int tick;
    private int id;
    private boolean running;

    public TileTick(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.virtualFurnaceAPI = virtualFurnaceAPI;
        this.tileManager = virtualFurnaceAPI.getTileManager();
        this.tick = 0;
    }

    public void start() {
        BukkitTask task = this.runTaskTimerAsynchronously((Plugin)this.virtualFurnaceAPI.getJavaPlugin(), 20L, 1L);
        this.id = task.getTaskId();
    }

    public void run() {
        this.running = true;
        try {
            for (VirtualChunk chunk : this.tileManager.getLoadedChunks()) {
                if (!this.running) {
                    return;
                }
                chunk.tick();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.tick;
        if (this.tick >= 6000) {
            this.tick = 0;
            this.tileManager.saveAllTiles();
        }
        this.running = false;
    }

    public synchronized void cancel() throws IllegalStateException {
        this.running = false;
        Bukkit.getScheduler().cancelTask(this.id);
    }
}

