/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.api.virtualfurnace.api.chunk.ChunkKey;
import tk.shanebee.bee.api.virtualfurnace.api.chunk.VirtualChunk;
import tk.shanebee.bee.api.virtualfurnace.api.machine.Furnace;
import tk.shanebee.bee.api.virtualfurnace.api.property.FurnaceProperties;
import tk.shanebee.bee.api.virtualfurnace.api.tile.FurnaceTile;
import tk.shanebee.bee.api.virtualfurnace.api.tile.Tile;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

public class TileManager {
    private final Map<ChunkKey, VirtualChunk> chunkMap = new HashMap<ChunkKey, VirtualChunk>();
    private final List<VirtualChunk> loadedChunks = new ArrayList<VirtualChunk>();
    private final List<Tile<?>> tiles = new ArrayList();
    private final VirtualFurnaceAPI virtualFurnaceAPI;
    private File tileFile;
    private FileConfiguration tileConfig;

    public TileManager(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.virtualFurnaceAPI = virtualFurnaceAPI;
    }

    public void load() {
        this.loadTileConfig();
        this.loadTiles();
        this.loadChunks();
    }

    private void loadTileConfig() {
        if (this.tileFile == null) {
            this.tileFile = new File(this.virtualFurnaceAPI.getJavaPlugin().getDataFolder(), "tiles.yml");
        }
        if (!this.tileFile.exists()) {
            this.virtualFurnaceAPI.getJavaPlugin().saveResource("tiles.yml", false);
        }
        this.tileConfig = YamlConfiguration.loadConfiguration((File)this.tileFile);
    }

    private void loadTiles() {
        ConfigurationSection section = this.tileConfig.getConfigurationSection("tiles");
        if (section != null) {
            for (String string : section.getKeys(true)) {
                if (section.get(string) instanceof FurnaceTile) {
                    this.tiles.add((FurnaceTile)section.get(string));
                    continue;
                }
                Util.log("&cFailed to load tile: " + section.get(string));
            }
        }
        Util.log("Loaded: &b" + this.tiles.size() + "&7 tiles");
    }

    private void loadChunks() {
        for (Tile<?> tile : this.tiles) {
            int z;
            int x = tile.getX() >> 4;
            ChunkKey key = new ChunkKey(x, z = tile.getZ() >> 4);
            if (!this.chunkMap.containsKey(key)) {
                this.chunkMap.put(key, new VirtualChunk(x, z, tile.getBukkitWorld()));
            }
            VirtualChunk chunk = this.chunkMap.get(key);
            chunk.addTile(tile);
            if (!tile.getBukkitWorld().isChunkLoaded(x, z)) continue;
            this.loadedChunks.add(chunk);
        }
        Util.log("Loaded: &b" + this.loadedChunks.size() + "&7/&b" + this.chunkMap.values().size() + "&7 virtual chunks");
    }

    public void saveTile(@NotNull Tile<?> tile, boolean saveToFile) {
        this.tileConfig.set("tiles." + tile.getString(), tile);
        if (saveToFile) {
            this.saveConfig();
        }
    }

    public void saveAllTiles() {
        for (Tile<?> tile : this.tiles) {
            this.saveTile(tile, false);
        }
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            this.tileConfig.save(this.tileFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void shutdown() {
        this.saveAllTiles();
        ArrayList<VirtualChunk> chunks = new ArrayList<VirtualChunk>(this.loadedChunks);
        for (VirtualChunk chunk : chunks) {
            chunk.removeAllPluginChunkTickets();
        }
        this.loadedChunks.clear();
        this.chunkMap.clear();
        this.tiles.clear();
    }

    public Collection<VirtualChunk> getChunks() {
        return Collections.unmodifiableCollection(this.chunkMap.values());
    }

    public Collection<VirtualChunk> getLoadedChunks() {
        return Collections.unmodifiableCollection(this.loadedChunks);
    }

    public boolean loadChunk(@NotNull VirtualChunk chunk) {
        return this.loadedChunks.add(chunk);
    }

    public boolean unloadChunk(@NotNull VirtualChunk chunk) {
        if (this.loadedChunks.contains(chunk) && !chunk.isForceLoaded()) {
            this.loadedChunks.remove(chunk);
            return true;
        }
        return false;
    }

    public boolean isChunkLoaded(@NotNull VirtualChunk chunk) {
        return this.loadedChunks.contains(chunk);
    }

    public VirtualChunk getChunk(int x, int z) {
        return this.chunkMap.get(new ChunkKey(x, z));
    }

    public VirtualChunk getChunk(@NotNull Chunk chunk) {
        for (VirtualChunk mChunk : this.chunkMap.values()) {
            if (chunk.getX() != mChunk.getX() || chunk.getZ() != mChunk.getZ()) continue;
            return mChunk;
        }
        return null;
    }

    public List<Tile<?>> getAllTiles() {
        return this.tiles;
    }

    public Tile<?> getTile(@NotNull Block block) {
        return this.getTile(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    public Tile<?> getTile(int x, int y, int z, @NotNull World world) {
        for (Tile<?> tile : this.tiles) {
            if (tile.getX() != x || tile.getY() != y || tile.getZ() != z || tile.getBukkitWorld() != world) continue;
            return tile;
        }
        return null;
    }

    public boolean removeTile(@NotNull Tile<?> tile) {
        ChunkKey key = new ChunkKey(tile.getX() >> 4, tile.getZ() >> 4);
        VirtualChunk virtualChunk = this.chunkMap.get(key);
        if (virtualChunk != null) {
            virtualChunk.removeTile(tile);
            this.tiles.remove(tile);
            this.tileConfig.set("tiles." + tile.getString(), null);
            this.saveConfig();
            return true;
        }
        return false;
    }

    public FurnaceTile createFurnaceTile(@NotNull Block block, @NotNull Furnace furnace) {
        return this.createFurnaceTile(block.getX(), block.getY(), block.getZ(), block.getWorld(), furnace, null, null);
    }

    public FurnaceTile createFurnaceTile(@NotNull Block block, @NotNull Furnace furnace, @NotNull Consumer<FurnaceTile> furnaceTileConsumer) {
        return this.createFurnaceTile(block.getX(), block.getY(), block.getZ(), block.getWorld(), furnace, null, furnaceTileConsumer);
    }

    public FurnaceTile createFurnaceTile(@NotNull Block block, @NotNull String name, @NotNull FurnaceProperties properties) {
        Furnace furnace = new Furnace(name, properties);
        return this.createFurnaceTile(block.getX(), block.getY(), block.getZ(), block.getWorld(), furnace, null, null);
    }

    public FurnaceTile createFurnaceTile(@NotNull Block block, @NotNull String name, @NotNull FurnaceProperties properties, @NotNull Consumer<FurnaceTile> furnaceTileConsumer) {
        Furnace furnace = new Furnace(name, properties);
        return this.createFurnaceTile(block.getX(), block.getY(), block.getZ(), block.getWorld(), furnace, null, furnaceTileConsumer);
    }

    public FurnaceTile createFurnaceTile(int x, int y, int z, @NotNull World world, @NotNull String name, @NotNull FurnaceProperties properties) {
        Furnace furnace = new Furnace(name, properties);
        return this.createFurnaceTile(x, y, z, world, furnace, null, null);
    }

    public FurnaceTile createFurnaceTile(int x, int y, int z, @NotNull World world, @NotNull String name, @NotNull FurnaceProperties properties, @NotNull Consumer<Furnace> furnaceConsumer) {
        Furnace furnace = new Furnace(name, properties);
        return this.createFurnaceTile(x, y, z, world, furnace, furnaceConsumer, null);
    }

    public FurnaceTile createFurnaceTile(int x, int y, int z, @NotNull World world, @NotNull Furnace furnace) {
        return this.createFurnaceTile(x, y, z, world, furnace, null, null);
    }

    public FurnaceTile createFurnaceTile(int x, int y, int z, @NotNull World world, @NotNull Furnace furnace, @NotNull Consumer<Furnace> furnaceConsumer) {
        return this.createFurnaceTile(x, y, z, world, furnace, furnaceConsumer, null);
    }

    public FurnaceTile createFurnaceTile(int x, int y, int z, @NotNull World world, @NotNull Furnace furnace, Consumer<Furnace> furnaceConsumer, Consumer<FurnaceTile> furnaceTileConsumer) {
        VirtualChunk virtualChunk;
        if (furnaceConsumer != null) {
            furnaceConsumer.accept(furnace);
        }
        FurnaceTile tile = new FurnaceTile(furnace, x, y, z, world);
        if (furnaceTileConsumer != null) {
            furnaceTileConsumer.accept(tile);
        }
        this.tiles.add(tile);
        this.saveTile(tile, true);
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        ChunkKey key = new ChunkKey(chunkX, chunkZ);
        if (!this.chunkMap.containsKey(key)) {
            this.chunkMap.put(key, new VirtualChunk(chunkX, chunkZ, world));
        }
        if ((virtualChunk = this.chunkMap.get(key)).isBukkitChunkLoaded()) {
            this.loadedChunks.add(virtualChunk);
        }
        virtualChunk.addTile(tile);
        return tile;
    }
}

