/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity Visibility")
@Description(value={"Get/set visibility for entities. Armor stands on all versions, ItemFrames on 1.15+ and LivingEntities on 1.16.3+"})
@Examples(value={"set visibility of target entity to false", "set {_v} to visibility of target entity", "if visibility of target entity is true:"})
@Since(value="1.7.0")
public class ExprEntityVisibility
extends PropertyExpression<Entity, Boolean> {
    private static final boolean ITEM_FRAME = Skript.methodExists(ItemFrame.class, (String)"setVisible", (Class[])new Class[]{Boolean.TYPE});
    private static final boolean LIVING_ENTITY = Skript.methodExists(LivingEntity.class, (String)"setInvisible", (Class[])new Class[]{Boolean.TYPE});

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Boolean @NotNull [] get(@NotNull Event e, Entity @NotNull [] source) {
        return (Boolean[])this.get(source, (Converter)new Getter<Boolean, Entity>(){

            @Nullable
            public Boolean get(@NotNull Entity entity) {
                if (entity instanceof ArmorStand) {
                    return ((ArmorStand)entity).isVisible();
                }
                if (entity instanceof ItemFrame && ITEM_FRAME) {
                    return ((ItemFrame)entity).isVisible();
                }
                if (entity instanceof LivingEntity && LIVING_ENTITY) {
                    return !((LivingEntity)entity).isInvisible();
                }
                return null;
            }
        });
    }

    @Nullable
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean[].class});
        }
        return null;
    }

    public void change(@NotNull Event event, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        boolean visible = delta != null && (Boolean)delta[0] != false;
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (entity instanceof ArmorStand) {
                ((ArmorStand)entity).setVisible(visible);
                continue;
            }
            if (entity instanceof ItemFrame && ITEM_FRAME) {
                ((ItemFrame)entity).setVisible(visible);
                continue;
            }
            if (!(entity instanceof LivingEntity) || !LIVING_ENTITY) continue;
            ((LivingEntity)entity).setInvisible(!visible);
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "visibility of " + this.getExpr().toString(e, d);
    }

    static {
        ExprEntityVisibility.register(ExprEntityVisibility.class, Boolean.class, (String)"visibility", (String)"entities");
    }
}

