/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.board.objects;

import ch.njol.skript.Skript;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import tk.shanebee.bee.api.util.Validate;

public class Board {
    private static final boolean LEGACY = !Skript.isRunningMinecraft((int)1, (int)13);
    private static final int MAX = LEGACY ? 32 : 128;
    private static final Map<Player, Board> BOARD_MAP = new HashMap<Player, Board>();
    private final Player player;
    private final Scoreboard oldScoreboard;
    private final Scoreboard scoreboard;
    private final Objective board;
    private final Team[] lines = new Team[15];
    private final String[] entries = new String[]{"&1&r", "&2&r", "&3&r", "&4&r", "&5&r", "&6&r", "&7&r", "&8&r", "&9&r", "&0&r", "&a&r", "&b&r", "&c&r", "&d&r", "&e&r"};
    private boolean on;

    public static Board getBoard(Player player) {
        return BOARD_MAP.get(player);
    }

    public static void createBoard(Player player) {
        Board board = new Board(player);
        BOARD_MAP.put(player, board);
    }

    public static void removeBoard(Player player) {
        if (BOARD_MAP.containsKey(player)) {
            BOARD_MAP.get(player).clearBoard();
        }
        BOARD_MAP.remove(player);
    }

    public static void clearBoards() {
        for (Board board : BOARD_MAP.values()) {
            board.clearBoard();
        }
        BOARD_MAP.clear();
    }

    public Board(Player player) {
        int i;
        this.player = player;
        this.on = true;
        this.oldScoreboard = player.getScoreboard();
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.player.setScoreboard(this.scoreboard);
        this.board = LEGACY ? this.scoreboard.registerNewObjective("Board", "dummy") : this.scoreboard.registerNewObjective("Board", "dummy", "Board");
        this.board.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.board.setDisplayName(" ");
        for (i = 0; i < 15; ++i) {
            this.lines[i] = this.scoreboard.registerNewTeam("line" + (i + 1));
        }
        for (i = 0; i < 15; ++i) {
            this.lines[i].addEntry(this.getColString(this.entries[i]));
        }
    }

    public void setTitle(String title) {
        this.board.setDisplayName(this.getColString(title));
    }

    public void setLine(int line, String text) {
        Validate.isBetween(line, 1, 15);
        Team t = this.lines[line - 1];
        if (text.length() > MAX / 2) {
            String prefix = this.getColString(text.substring(0, MAX / 2));
            String lastColor = ChatColor.getLastColors((String)prefix);
            int splitMax = Math.min(text.length(), MAX - lastColor.length());
            String suffix = this.getColString(lastColor + text.substring(MAX / 2, splitMax));
            if (prefix.substring(MAX / 2 - 1, MAX / 2).equalsIgnoreCase("\u00a7")) {
                prefix = prefix.substring(0, MAX / 2 - 1);
                int length = text.length() > MAX - 2 ? MAX - 1 : text.length();
                suffix = this.getColString(text.substring(MAX / 2 - 1, length));
            }
            t.setPrefix(prefix);
            t.setSuffix(suffix);
        } else {
            String prefix = this.getColString(text);
            t.setPrefix(prefix);
            t.setSuffix("");
        }
        this.board.getScore(this.getColString(this.entries[line - 1])).setScore(line);
    }

    public void deleteLine(int line) {
        Validate.isBetween(line, 1, 15);
        this.scoreboard.resetScores(this.getColString(this.entries[line - 1]));
    }

    public void clearBoard() {
        for (int i = 1; i < 16; ++i) {
            this.deleteLine(i);
        }
    }

    public void toggle(boolean on) {
        if (on) {
            this.player.setScoreboard(this.scoreboard);
            this.on = true;
        } else {
            this.player.setScoreboard(this.oldScoreboard);
            this.on = false;
        }
    }

    public boolean isOn() {
        return this.on;
    }

    private String getColString(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

