/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

public class Fuel
implements Keyed {
    private static final List<Fuel> VANILLA_FUELS = new ArrayList<Fuel>();
    public static final Fuel LAVA_BUCKET = Fuel.get("lava_bucket", Material.LAVA_BUCKET, 20000);
    public static final Fuel BLOCK_OF_COAL = Fuel.get("block_of_coal", Material.COAL_BLOCK, 16000);
    public static final Fuel DRIED_KELP_BLOCK = Fuel.get("dried_kelp_block", Material.DRIED_KELP_BLOCK, 4000);
    public static final Fuel BLAZE_ROD = Fuel.get("blaze_rod", Material.BLAZE_ROD, 2400);
    public static final Fuel COAL = Fuel.get("coal", Material.COAL, 1600);
    public static final Fuel CHARCOAL = Fuel.get("charcoal", Material.CHARCOAL, 1600);
    public static final Fuel ANY_BOAT = Fuel.get("any_boat", (Tag<Material>)Tag.ITEMS_BOATS, 1200);
    public static final Fuel ANY_LOG = Fuel.get("any_log", (Tag<Material>)Tag.LOGS, 300);
    public static final Fuel ANY_PLANK = Fuel.get("any_plank", (Tag<Material>)Tag.PLANKS, 300);
    public static final Fuel ANY_WOOD_PRESSURE_PLATE = Fuel.get("any_wood_pressure_plate", (Tag<Material>)Tag.WOODEN_PRESSURE_PLATES, 300);
    public static final Fuel ANY_WOOD_STAIR = Fuel.get("any_wood_stair", (Tag<Material>)Tag.WOODEN_STAIRS, 300);
    public static final Fuel ANY_WOOD_TRAPDOOR = Fuel.get("any_wood_trapdoor", (Tag<Material>)Tag.WOODEN_TRAPDOORS, 300);
    public static final Fuel CRAFTING_TABLE = Fuel.get("crafting_table", Material.CRAFTING_TABLE, 300);
    public static final Fuel BOOKSHELF = Fuel.get("bookshelf", Material.BOOKSHELF, 300);
    public static final Fuel CHEST = Fuel.get("chest", Material.CHEST, 300);
    public static final Fuel TRAPPED_CHEST = Fuel.get("trapped_chest", Material.TRAPPED_CHEST, 300);
    public static final Fuel DAYLIGHT_DETECTOR = Fuel.get("daylight_detector", Material.DAYLIGHT_DETECTOR, 300);
    public static final Fuel JUKEBOX = Fuel.get("jukebox", Material.JUKEBOX, 300);
    public static final Fuel NOTE_BLOCK = Fuel.get("note_block", Material.NOTE_BLOCK, 300);
    public static final Fuel MUSHROOM_STEM = Fuel.get("mushroom_stem", Material.MUSHROOM_STEM, 300);
    public static final Fuel BROWN_MUSHROOM_BLOCK = Fuel.get("brown_mushroom_block", Material.BROWN_MUSHROOM_BLOCK, 300);
    public static final Fuel RED_MUSHROOM_BLOCK = Fuel.get("red_mushroom_block", Material.RED_MUSHROOM_BLOCK, 300);
    public static final Fuel ANY_BANNER = Fuel.get("any_banner", (Tag<Material>)Tag.BANNERS, 300);
    public static final Fuel ANY_WOODEN_SLAB = Fuel.get("any_wooden_slab", (Tag<Material>)Tag.WOODEN_SLABS, 150);
    public static final Fuel BOW = Fuel.get("bow", Material.BOW, 300);
    public static final Fuel FISHING_ROD = Fuel.get("fishing_rod", Material.FISHING_ROD, 300);
    public static final Fuel LADDER = Fuel.get("ladder", Material.LADDER, 300);
    public static final Fuel ANY_WOODEN_BUTTON = Fuel.get("any_wooden_button", (Tag<Material>)Tag.WOODEN_BUTTONS, 100);
    public static final Fuel WOODEN_PICKAXE = Fuel.get("wooden_pickaxe", Material.WOODEN_PICKAXE, 200);
    public static final Fuel WOODEN_SHOVEL = Fuel.get("wooden_shovel", Material.WOODEN_SHOVEL, 200);
    public static final Fuel WOODEN_HOE = Fuel.get("wooden_hoe", Material.WOODEN_HOE, 200);
    public static final Fuel WOODEN_AXE = Fuel.get("wooden_axe", Material.WOODEN_AXE, 200);
    public static final Fuel WOODEN_SWORD = Fuel.get("wooden_sword", Material.WOODEN_SWORD, 200);
    public static final Fuel ANY_WOODEN_DOOR = Fuel.get("any_wooden_door", (Tag<Material>)Tag.WOODEN_TRAPDOORS, 200);
    public static final Fuel BOWL = Fuel.get("bowl", Material.BOWL, 100);
    public static final Fuel ANY_SAPLING = Fuel.get("any_sapling", (Tag<Material>)Tag.SAPLINGS, 100);
    public static final Fuel STICK = Fuel.get("stick", Material.STICK, 100);
    public static final Fuel ANY_WOOL = Fuel.get("any_wool", (Tag<Material>)Tag.WOOL, 100);
    public static final Fuel ANY_CARPET = Fuel.get("any_carpet", (Tag<Material>)Tag.CARPETS, 67);
    public static final Fuel SCAFFOLDING;
    public static final Fuel CARTOGRAPHY_TABLE;
    public static final Fuel FLETCHING_TABLE;
    public static final Fuel SMITHING_TABLE;
    public static final Fuel LECTERN;
    public static final Fuel COMPOSTER;
    public static final Fuel BARREL;
    public static final Fuel LOOM;
    public static final Fuel ANY_SIGN;
    public static final Fuel BAMBOO;
    public static final Fuel ANY_WOOD_FENCE;
    private final NamespacedKey key;
    private final Material material;
    private final Tag<Material> tag;
    private final int burnTime;

    private static Fuel get(String name, Material fuel, int burnTicks) {
        Fuel fuel1 = new Fuel(Util.getKey("mc_fuel_" + name), fuel, burnTicks);
        VANILLA_FUELS.add(fuel1);
        return fuel1;
    }

    private static Fuel get(String name, Tag<Material> fuelTag, int burnTicks) {
        Fuel fuel = new Fuel(Util.getKey("mc_fuel_" + name), fuelTag, burnTicks);
        VANILLA_FUELS.add(fuel);
        return fuel;
    }

    public static List<Fuel> getVanillaFuels() {
        return Collections.unmodifiableList(VANILLA_FUELS);
    }

    public Fuel(NamespacedKey key, Material fuelMaterial, int burnTime) {
        this.key = key;
        this.material = fuelMaterial;
        this.tag = null;
        this.burnTime = burnTime;
    }

    public Fuel(NamespacedKey key, Tag<Material> fuelTag, int burnTime) {
        this.key = key;
        this.material = null;
        this.tag = fuelTag;
        this.burnTime = burnTime;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Deprecated
    public Material getFuel() {
        return this.material;
    }

    public Material getFuelMaterial() {
        return this.material;
    }

    public Tag<Material> getTag() {
        return this.tag;
    }

    public boolean matchFuel(Material material) {
        if (this.material != null && this.material == material) {
            return true;
        }
        return this.tag != null && this.tag.isTagged((Keyed)material);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fuel fuel = (Fuel)o;
        return this.burnTime == fuel.burnTime && Objects.equals(this.key, fuel.key) && this.material == fuel.material && Objects.equals(this.tag, fuel.tag);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.material, this.tag, this.burnTime);
    }

    public String toString() {
        return "Fuel{key=" + this.key + (this.material != null ? ", material=" + this.material : ", tag=" + this.tag.getKey()) + ", burnTime=" + this.burnTime + '}';
    }

    static {
        if (Util.isRunningMinecraft(1, 14)) {
            SCAFFOLDING = Fuel.get("scaffolding", Material.SCAFFOLDING, 400);
            CARTOGRAPHY_TABLE = Fuel.get("cartography_table", Material.CARTOGRAPHY_TABLE, 300);
            FLETCHING_TABLE = Fuel.get("fletching_table", Material.FLETCHING_TABLE, 300);
            SMITHING_TABLE = Fuel.get("smithing_table", Material.SMITHING_TABLE, 300);
            LECTERN = Fuel.get("lectern", Material.LECTERN, 300);
            COMPOSTER = Fuel.get("composter", Material.COMPOSTER, 300);
            BARREL = Fuel.get("barrel", Material.BARREL, 300);
            LOOM = Fuel.get("loom", Material.LOOM, 300);
            ANY_SIGN = Fuel.get("any_sign", (Tag<Material>)Tag.SIGNS, 200);
            BAMBOO = Fuel.get("bamboo", Material.BAMBOO, 50);
            ANY_WOOD_FENCE = Fuel.get("any_wood_fence", (Tag<Material>)Tag.WOODEN_FENCES, 300);
        } else {
            SCAFFOLDING = null;
            CARTOGRAPHY_TABLE = null;
            FLETCHING_TABLE = null;
            SMITHING_TABLE = null;
            LECTERN = null;
            COMPOSTER = null;
            BARREL = null;
            LOOM = null;
            BAMBOO = null;
            ANY_SIGN = Fuel.get("any_sign", Material.getMaterial((String)"SIGN"), 200);
            ANY_WOOD_FENCE = Fuel.get("any_wood_fence", Material.OAK_FENCE, 300);
        }
    }
}

