/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingRecipe;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.elements.recipe.util.RecipeUtil;

@Name(value="Recipe - Smithing")
@Description(value={"Register a new smithing recipe. The ID will be the name given to this recipe. IDs may only contain letters, numbers, periods, hyphens and underscores. Used for recipe discovery/unlocking recipes for players. Requires MC 1.13+"})
@Examples(value={"on load:", "\tregister new smithing recipe for diamond chestplate using an iron chestplate and a diamond with id \"smith_diamond_chestplate\""})
@RequiredPlugins(value={"1.16+"})
@Since(value="1.4.2")
public class EffSmithingRecipe
extends Effect {
    private Expression<ItemType> result;
    private Expression<ItemType> base;
    private Expression<ItemType> addition;
    private Expression<String> key;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parse) {
        this.result = exprs[0];
        this.base = exprs[1];
        this.addition = exprs[2];
        this.key = exprs[3];
        return true;
    }

    protected void execute(@NotNull Event event) {
        ItemType result = (ItemType)this.result.getSingle(event);
        ItemType base = (ItemType)this.base.getSingle(event);
        ItemType addition = (ItemType)this.addition.getSingle(event);
        if (result == null) {
            RecipeUtil.error("Error registering smithing recipe - result is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        if (base == null) {
            RecipeUtil.error("Error registering smithing recipe - base is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        if (addition == null) {
            RecipeUtil.error("Error registering smithing recipe - addition is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        NamespacedKey key = RecipeUtil.getKey((String)this.key.getSingle(event));
        RecipeUtil.removeRecipeByKey(key);
        SmithingRecipe recipe = new SmithingRecipe(key, result.getRandom(), (RecipeChoice)new RecipeChoice.ExactChoice(base.getRandom()), (RecipeChoice)new RecipeChoice.ExactChoice(addition.getRandom()));
        Bukkit.addRecipe((Recipe)recipe);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "Register new smithing recipe for " + this.result.toString(e, d) + " using " + this.base.toString(e, d) + " and " + this.addition.toString(e, d) + " with id " + this.key.toString(e, d);
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)16)) {
            Skript.registerEffect(EffSmithingRecipe.class, (String[])new String[]{"register [new] smithing recipe for %itemtype% using %itemtype% and %itemtype% with id %string%"});
        }
    }
}

