/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.path.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.entity.Pathfinder;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Pathfinding - Path Points")
@Description(value={"Get all the points along an entity's pathfinding path. Requires Paper 1.13+"})
@Examples(value={"set {_path::*} to path points of last spawned sheep"})
@Since(value="1.5.0")
public class ExprPath
extends SimpleExpression<Location> {
    private Expression<LivingEntity> entities;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        return true;
    }

    @Nullable
    protected Location[] get(@NotNull Event e) {
        ArrayList locations = new ArrayList();
        for (LivingEntity entity : (LivingEntity[])this.entities.getArray(e)) {
            Pathfinder.PathResult result;
            if (!(entity instanceof Mob) || (result = ((Mob)entity).getPathfinder().getCurrentPath()) == null) continue;
            locations.addAll(result.getPoints());
        }
        return locations.toArray(new Location[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "path points of " + this.entities.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprPath.class, Location.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"path [points] of %livingentities%"});
    }
}

