/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBTApi;
import tk.shanebee.bee.api.util.Util;

@Name(value="NBT - Tag")
@Description(value={"Returns the value of the specified tag of the specified NBT. Also supports getting nested tags using a semi colon as a delimiter. ", "If the return value is a list, you can use it as a list, as it will automatically split it for ya. ", "As of 1.6.0 you can also set/delete tags, but only with NBT compounds, not NBT strings. Do note that setting the tag of an item ", "will not update it, you will have to create a variable for the NBT compound of the item, set the tag of that variable, then set the item back ", "using the 'nbt item of' expression. I understand this is a bit convoluted but unfortunately that is just how it works. See examples. ", "Also note that you can NOT create custom tags for entities/blocks."})
@Examples(value={"set {_tag} to tag \"Invulnerable\" of targeted entity's nbt", "send \"Tag: %tag \"\"CustomName\"\" of nbt of target entity%\" to player", "set {_tag} to \"Enchantments\" tag of nbt of player's tool", "delete tag \"CustomTag\" of {_nbt}", "set {_tag} to \"BlockEntityTag;Items\" tag of nbt of target block", "", "set {_n} to nbt compound of player's tool", "set tag \"tag;Damage\" of {_n} to 500", "set player's tool to nbt item of {_n}"})
@Since(value="1.0.0")
public class ExprTagOfNBT
extends SimpleExpression<Object> {
    private static final NBTApi NBT_API;
    private static final boolean DEBUG;
    private Expression<String> tag;
    private Expression<Object> nbt;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.tag = exprs[0];
        this.nbt = exprs[1];
        return true;
    }

    @Nullable
    protected Object[] get(@NotNull Event e) {
        String n;
        String t = (String)this.tag.getSingle(e);
        Object object = this.nbt.getSingle(e);
        String string = n = object instanceof NBTCompound ? object.toString() : (String)object;
        assert (t != null);
        if (t.contains(";")) {
            return this.getNested(t, n);
        }
        Object nbt = NBT_API.getTag(t, n);
        if (nbt instanceof ArrayList) {
            return ((ArrayList)nbt).toArray();
        }
        return new Object[]{nbt};
    }

    @Nullable
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public void change(@NotNull Event e, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        Object object = this.nbt.getSingle(e);
        if (!(object instanceof NBTCompound)) {
            return;
        }
        String tag = (String)this.tag.getSingle(e);
        NBTCompound compound = (NBTCompound)object;
        if (tag == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            if (delta == null) {
                return;
            }
            NBT_API.setTag(tag, compound, delta);
        } else if (mode == Changer.ChangeMode.DELETE) {
            NBT_API.deleteTag(tag, compound);
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "Tag \"" + this.tag.toString(e, d) + "\" of " + this.nbt.toString(e, d);
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    private Object[] getNested(String tag, String nbt) {
        if (nbt == null) {
            return null;
        }
        String[] split = tag.split(";");
        Object nbtNew = nbt;
        for (String s : split) {
            NBTContainer container = new NBTContainer(nbtNew.toString());
            if ((nbtNew = NBT_API.getTag(s, container.toString())) != null) continue;
            if (DEBUG) {
                Util.skriptError("Invalid tag \"&b" + s + "&7\" in &b" + container.toString());
            }
            return null;
        }
        if (nbtNew instanceof ArrayList) {
            return ((ArrayList)nbtNew).toArray();
        }
        return new Object[]{nbtNew};
    }

    static {
        Skript.registerExpression(ExprTagOfNBT.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"tag %string% of %string/nbtcompound%", "%string% tag of %string/nbtcompound%"});
        NBT_API = SkBee.getPlugin().getNbtApi();
        DEBUG = SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG;
    }
}

