/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.reflection.SkReflection;

@Name(value="Hidden Item Flags")
@Description(value={"Hides the item flags on items, allowing you to make super duper custom items. Dye item flag added in 1.5.0 and only available on 1.16.2+."})
@Examples(value={"set player's tool to player's tool with attribute flag hidden", "give player 1 diamond sword of sharpness 5 with hidden enchants flag", "set {_tool} to player's tool with all flags hidden", "give player potion of harming with hidden potion effects flag", "set {_b} to leather boots with dye flag hidden"})
@Since(value="1.0.0")
public class ExprHiddenFlags
extends SimplePropertyExpression<ItemType, ItemType> {
    private static final boolean HAS_DYE_FLAG = Skript.isRunningMinecraft((int)1, (int)16, (int)2);
    private int parse = 0;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.parse = parseResult.mark;
        return true;
    }

    @Nullable
    public ItemType convert(@NotNull ItemType item) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = SkReflection.getMeta(item);
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(item.getMaterial());
        }
        switch (this.parse) {
            case 0: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                if (!HAS_DYE_FLAG) break;
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                break;
            }
            case 1: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                break;
            }
            case 2: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                break;
            }
            case 3: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                break;
            }
            case 4: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                break;
            }
            case 5: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                break;
            }
            case 6: {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            }
        }
        SkReflection.setMeta(item, meta);
        return item;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "Hidden Item Flags";
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String[] flags = new String[]{"all", "enchant", "destroy", "potion effect", "unbreakable", "attribute", "dye"};
        return this.getExpr().toString(e, d) + " with " + flags[this.parse] + " flags hidden";
    }

    static {
        if (HAS_DYE_FLAG) {
            Skript.registerExpression(ExprHiddenFlags.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"%itemtype% with (0\u00a6all|1\u00a6enchant[s]|2\u00a6destroy[s]|3\u00a6potion[ ]effect[s]|4\u00a6unbreakable|5\u00a6attribute[s]|6\u00a6dye) flag[s] hidden", "%itemtype% with hidden (0\u00a6all|1\u00a6enchant[s]|2\u00a6destroy[s]|3\u00a6potion[ ]effect[s]|4\u00a6unbreakable|5\u00a6attribute[s]|6\u00a6dye) flag[s]"});
        } else {
            Skript.registerExpression(ExprHiddenFlags.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"%itemtype% with (0\u00a6all|1\u00a6enchant[s]|2\u00a6destroy[s]|3\u00a6potion[ ]effect[s]|4\u00a6unbreakable|5\u00a6attribute[s]) flag[s] hidden", "%itemtype% with hidden (0\u00a6all|1\u00a6enchant[s]|2\u00a6destroy[s]|3\u00a6potion[ ]effect[s]|4\u00a6unbreakable|5\u00a6attribute[s]) flag[s]"});
        }
    }
}

