/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import tk.shanebee.bee.api.util.PlayerUtils;

@Name(value="Simplified Debug Screen")
@Description(value={"This effect allows you to reduce a big part of the player's debug screen.This can be useful for survival servers where you dont want your players to know their coords."})
@Examples(value={"on join:", "\treduce debug screen for player"})
@Since(value="1.3.0")
public class EffHideDebug
extends Effect {
    private Expression<Player> players;
    private boolean hide;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.hide = parseResult.mark == 1;
        return true;
    }

    protected void execute(Event e) {
        for (Player player : (Player[])this.players.getAll(e)) {
            if (this.hide) {
                PlayerUtils.disableF3(player);
                continue;
            }
            PlayerUtils.enableF3(player);
        }
    }

    public String toString(@Nullable Event e, boolean d) {
        return (this.hide ? "hide" : "show") + " debug screen for " + this.players.toString(e, d);
    }

    static {
        Skript.registerEffect(EffHideDebug.class, (String[])new String[]{"(0\u00a6reduce|1\u00a6expand) debug [screen] for %players%"});
    }
}

