/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.reflection.ReflectionUtils;

public class ChatReflection {
    private static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];

    public static String getPrettyNBT(NBTCompound compound, String split) {
        String prettyM = Ver.getPretty(split != null);
        if (prettyM == null) {
            return null;
        }
        Object nmsNBT = compound.getCompound();
        Class<?> iChatBaseComponent = ReflectionUtils.getNMSClass("IChatBaseComponent");
        Class<?> craftChatMessageClass = ReflectionUtils.getOBCClass("util.CraftChatMessage");
        try {
            Object prettyComponent;
            if (split != null) {
                Method prettyMethod = nmsNBT.getClass().getMethod(prettyM, String.class, Integer.TYPE);
                prettyComponent = prettyMethod.invoke(nmsNBT, split, 0);
            } else {
                Method prettyMethod = nmsNBT.getClass().getMethod(prettyM, new Class[0]);
                prettyComponent = prettyMethod.invoke(nmsNBT, new Object[0]);
            }
            assert (craftChatMessageClass != null);
            Method fromComponent = craftChatMessageClass.getMethod("fromComponent", iChatBaseComponent);
            return (String)fromComponent.invoke(craftChatMessageClass, prettyComponent);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static enum Ver {
        V_1_13_R2("v1_13_R2", "k", "a"),
        V_1_14_R1("v1_14_R1", "k", "a"),
        V_1_15_R1("v1_15_R1", "l", "a"),
        V_1_16_R1("v1_16_R1", "l", "a"),
        V_1_16_R2("v1_16_R2", "l", "a");

        private final String version;
        private final String pretty;
        private final String prettySplit;

        private Ver(String version, String pretty, String prettySplit) {
            this.version = version;
            this.pretty = pretty;
            this.prettySplit = prettySplit;
        }

        private static String getPretty(boolean split) {
            for (Ver value : Ver.values()) {
                if (!value.version.equalsIgnoreCase(VERSION)) continue;
                if (split) {
                    return value.prettySplit;
                }
                return value.pretty;
            }
            return null;
        }
    }
}

