/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Text Component - New Text Component")
@Description(value={"Create a new text component. Can have hover and click events added to it. You can also create a translate component, ", "this will send to the client, and the client will translate based on their language. You can use either an item type or a ", "translate string, you can find these in your Minecraft jar 'assets/minecraft/lang/<lang file>.json'.", "Some components have extra objects, you can use strings or other text components here."})
@Examples(value={"set {_comp::1} to text component from \"hi player \"", "set {_comp::2} to text component of \"hover over me for a special message!\"", "set hover event of {_comp::2} to hover event to show \"OoO look ma I'm hovering!\"", "send component {_comp::*} to player", "", "set {_t} to translate component from player's tool", "set {_t} to translate component from \"item.minecraft.milk_bucket\"", "set {_death} to translate component from \"death.fell.accident.ladder\" using player's name", "set {_assist} to translate component \"death.fell.assist\" using victim's name and attacker's name"})
@Since(value="1.5.0")
public class ExprTextComponent
extends SimpleExpression<BaseComponent> {
    private int pattern;
    private Expression<Object> translation;
    private Expression<Object> objects;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.translation = exprs[0];
        this.objects = this.pattern == 2 ? exprs[1] : null;
        return true;
    }

    @Nullable
    protected BaseComponent[] get(@NotNull Event e) {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        for (Object object : this.translation.getArray(e)) {
            TextComponent component;
            if (this.pattern == 0) {
                component = new TextComponent((String)object);
            } else if (this.pattern == 1) {
                String translate;
                component = new TranslatableComponent();
                if (object instanceof ItemType) {
                    ItemType itemType = (ItemType)object;
                    String type = itemType.getMaterial().isBlock() ? "block" : "item";
                    translate = type + ".minecraft." + ((String)itemType.getRawNames().get(0)).replace("minecraft:", "");
                } else {
                    translate = (String)object;
                }
                ((TranslatableComponent)component).setTranslate(translate);
            } else {
                String string = (String)this.translation.getSingle(e);
                Object[] objects = this.objects.getAll(e);
                component = new TranslatableComponent(string, objects);
            }
            components.add(component);
        }
        return components.toArray(new BaseComponent[0]);
    }

    public boolean isSingle() {
        return this.translation.isSingle();
    }

    @NotNull
    public Class<? extends BaseComponent> getReturnType() {
        return BaseComponent.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "a new text component from " + this.translation.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprTextComponent.class, BaseComponent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] text component[s] (from|of) %strings%", "[a] [new] translate component[s] (from|of) %itemtypes/strings%", "[a] [new] translate component[s] (from|of) %string% (with|using) %objects%"});
    }
}

