/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.debug;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import tk.shanebee.bee.api.virtualfurnace.VirtualFurnace;
import tk.shanebee.bee.api.virtualfurnace.api.TileManager;
import tk.shanebee.bee.api.virtualfurnace.api.chunk.VirtualChunk;
import tk.shanebee.bee.api.virtualfurnace.api.machine.Furnace;
import tk.shanebee.bee.api.virtualfurnace.api.tile.FurnaceTile;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

public class Debug {
    private final VirtualFurnace plugin;
    private final TileManager tileManager;
    private boolean running;

    public Debug(VirtualFurnace plugin) {
        this.plugin = plugin;
        this.tileManager = plugin.getVirtualFurnaceAPI().getTileManager();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void loadDebugFurnaces(final int amount, final CommandSender sender) {
        this.running = true;
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                long start = System.currentTimeMillis();
                for (int i = 0; i < amount; ++i) {
                    Debug.this.plugin.getFurnaceManager().createFurnace("test-furnace", furnace -> {
                        furnace.setFuel(new ItemStack(Material.COAL, 64));
                        furnace.setInput(new ItemStack(Material.CHICKEN, 64));
                    });
                }
                Util.log(sender, "Created " + amount + " furnaces in " + (System.currentTimeMillis() - start) + " milliseconds.");
                Debug.this.running = false;
            }
        };
        runnable.runTaskLaterAsynchronously((Plugin)this.plugin, 0L);
    }

    public void loadDebugTiles(final int debug) {
        final World world = (World)Bukkit.getWorlds().get(0);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                for (int x = 0; x < debug; ++x) {
                    for (int z = 0; z < debug; ++z) {
                        Furnace furnace = new Furnace("test");
                        furnace.setFuel(new ItemStack(Material.COAL, 64));
                        furnace.setInput(new ItemStack(Material.CHICKEN, 64));
                        FurnaceTile furnaceTile = Debug.this.tileManager.createFurnaceTile(x << 4, 1, z << 4, world, furnace);
                        VirtualChunk virtualChunk = Debug.this.tileManager.getChunk(furnaceTile.getBlock().getChunk());
                        Debug.this.tileManager.loadChunk(virtualChunk);
                        virtualChunk.addPluginChunkTicket((Plugin)Debug.this.plugin);
                    }
                }
                Util.log("Chunks: &b" + Debug.this.tileManager.getChunks().size() + "&7 Loaded: &b" + Debug.this.tileManager.getLoadedChunks().size());
            }
        };
        runnable.runTaskLaterAsynchronously((Plugin)this.plugin, 0L);
    }
}

