/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api.task;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import tk.shanebee.bee.api.virtualfurnace.api.FurnaceManager;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.api.virtualfurnace.api.machine.Furnace;

public class FurnaceTick
extends BukkitRunnable {
    private final FurnaceManager furnaceManager;
    private final VirtualFurnaceAPI virtualFurnaceAPI;
    private int tick;
    private int id;
    private boolean running;

    public FurnaceTick(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.virtualFurnaceAPI = virtualFurnaceAPI;
        this.furnaceManager = virtualFurnaceAPI.getFurnaceManager();
        this.tick = 0;
    }

    public void start() {
        BukkitTask task = this.runTaskTimerAsynchronously((Plugin)this.virtualFurnaceAPI.getJavaPlugin(), 15L, 1L);
        this.id = task.getTaskId();
    }

    public void run() {
        this.running = true;
        try {
            for (Furnace furnace : this.furnaceManager.getAllFurnaces()) {
                if (!this.running) {
                    return;
                }
                furnace.tick();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.tick;
        if (this.tick >= 6000) {
            this.tick = 0;
            this.furnaceManager.saveAll();
        }
    }

    public synchronized void cancel() throws IllegalStateException {
        this.running = false;
        Bukkit.getScheduler().cancelTask(this.id);
    }
}

