/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.util.slot.Slot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTEntity;
import tk.shanebee.bee.api.NBT.NBTFile;
import tk.shanebee.bee.api.NBT.NBTItem;
import tk.shanebee.bee.api.NBT.NBTTileEntity;
import tk.shanebee.bee.api.NBT.NBTType;
import tk.shanebee.bee.api.NBT.NbtApiException;
import tk.shanebee.bee.api.reflection.SkReflection;
import tk.shanebee.bee.api.util.Util;
import tk.shanebee.bee.config.Config;

public class NBTApi {
    private final Config CONFIG = SkBee.getPlugin().getPluginConfig();

    public boolean validateNBT(String nbtString) {
        if (nbtString == null) {
            return false;
        }
        try {
            new NBTContainer(nbtString);
        }
        catch (Exception ex) {
            this.sendError(nbtString, ex);
            return false;
        }
        return true;
    }

    private void sendError(String error, Exception exception) {
        Util.skriptError("&cInvalid NBT: &b" + error + "&c");
        if (SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG && exception != null) {
            exception.printStackTrace();
        }
    }

    public void forceLoadNBT() {
        Util.log("&aLoading NBTApi...");
        NBTItem loadingItem = new NBTItem(new ItemStack(Material.STONE));
        loadingItem.mergeCompound(new NBTContainer("{}"));
        Util.log("&aSuccessfully loaded NBTApi!");
    }

    private File getFile(String fileName) {
        File file = new File(fileName = !fileName.endsWith(".dat") && !fileName.endsWith(".nbt") ? fileName + ".dat" : fileName);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    @Nullable
    public Object addNBT(@NotNull Object object, @NotNull String value, @NotNull ObjectType type) {
        if (!type.isAssignableFrom(object, this.CONFIG.SETTINGS_DEBUG)) {
            return null;
        }
        if (!this.validateNBT(value)) {
            return null;
        }
        switch (type) {
            case FILE: {
                File file = this.getFile((String)object);
                if (file == null) {
                    return null;
                }
                try {
                    NBTFile nbtFile = new NBTFile(file);
                    nbtFile.mergeCompound(new NBTContainer(value));
                    nbtFile.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
            case ITEM_STACK: {
                NBTItem item = new NBTItem((ItemStack)object);
                item.mergeCompound(new NBTContainer(value));
                return item.getItem();
            }
            case ITEM_TYPE: {
                ItemStack stack = ((ItemType)object).getRandom();
                if (stack == null) {
                    return null;
                }
                NBTItem nbtItemType = new NBTItem(stack);
                nbtItemType.mergeCompound(new NBTContainer(value));
                SkReflection.setMeta((ItemType)object, nbtItemType.getItem().getItemMeta());
                return object;
            }
            case SLOT: {
                ItemStack slotItemStack = ((Slot)object).getItem();
                if (slotItemStack != null) {
                    ((Slot)object).setItem((ItemStack)this.addNBT(slotItemStack, value, ObjectType.ITEM_STACK));
                }
                return object;
            }
            case ENTITY: {
                NBTEntity nbtEntity = new NBTEntity((Entity)object);
                nbtEntity.mergeCompound(new NBTContainer(value));
                return object;
            }
            case BLOCK: {
                NBTTileEntity tile = new NBTTileEntity(((Block)object).getState());
                try {
                    tile.mergeCompound(new NBTContainer(value));
                }
                catch (NbtApiException nbtApiException) {
                    // empty catch block
                }
                return object;
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unsupported ObjectType: " + (Object)((Object)type));
        }
        return null;
    }

    @Nullable
    public Object setNBT(@NotNull Object object, @NotNull String value, @NotNull ObjectType type) {
        if (!type.isAssignableFrom(object, this.CONFIG.SETTINGS_DEBUG)) {
            return null;
        }
        if (!this.validateNBT(value)) {
            return null;
        }
        switch (type) {
            case FILE: {
                return this.addNBT(object, value, ObjectType.FILE);
            }
            case ITEM_STACK: {
                ItemStack stack = new ItemStack(((ItemStack)object).getType());
                NBTItem nbtItemStack = new NBTItem(stack);
                nbtItemStack.mergeCompound(new NBTContainer(value));
                ((ItemStack)object).setItemMeta(nbtItemStack.getItem().getItemMeta());
                return object;
            }
            case ITEM_TYPE: {
                ItemStack itemStack = new ItemStack(((ItemType)object).getMaterial());
                NBTItem nbtItemType = new NBTItem(itemStack);
                nbtItemType.mergeCompound(new NBTContainer(value));
                SkReflection.setMeta((ItemType)object, nbtItemType.getItem().getItemMeta());
                return object;
            }
            case SLOT: {
                ItemStack slotItemStack = ((Slot)object).getItem();
                if (slotItemStack != null) {
                    ((Slot)object).setItem((ItemStack)this.setNBT(slotItemStack, value, ObjectType.ITEM_STACK));
                }
                return object;
            }
            case ENTITY: {
                return this.addNBT(object, value, ObjectType.ENTITY);
            }
            case BLOCK: {
                return this.addNBT(object, value, ObjectType.BLOCK);
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unsupported ObjectType: " + (Object)((Object)type));
        }
        return null;
    }

    @Nullable
    public String getNBT(@NotNull Object object, @NotNull ObjectType type) {
        if (!type.isAssignableFrom(object, this.CONFIG.SETTINGS_DEBUG)) {
            return null;
        }
        switch (type) {
            case FILE: {
                File file = this.getFile((String)object);
                if (file == null) {
                    return null;
                }
                NBTFile fileNBT = null;
                try {
                    fileNBT = new NBTFile(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (fileNBT == null) {
                    return null;
                }
                return fileNBT.toString();
            }
            case ITEM_STACK: {
                ItemStack itemStack = (ItemStack)object;
                if (itemStack.getType() == Material.AIR) {
                    return null;
                }
                NBTItem item = new NBTItem(itemStack);
                return item.toString();
            }
            case ITEM_STACK_FULL: {
                return NBTItem.convertItemtoNBT((ItemStack)object).toString();
            }
            case ITEM_TYPE: {
                ItemStack itemTypeStack = ((ItemType)object).getRandom();
                if (itemTypeStack == null) {
                    return null;
                }
                return this.getNBT(itemTypeStack, ObjectType.ITEM_STACK);
            }
            case ITEM_TYPE_FULL: {
                ItemStack itemTypeStackFull = ((ItemType)object).getRandom();
                if (itemTypeStackFull == null) {
                    return null;
                }
                return this.getNBT(itemTypeStackFull, ObjectType.ITEM_STACK_FULL);
            }
            case SLOT: {
                ItemStack slotItemStack = ((Slot)object).getItem();
                if (slotItemStack == null) {
                    return null;
                }
                return this.getNBT(slotItemStack, ObjectType.ITEM_STACK);
            }
            case SLOT_FULL: {
                ItemStack slotItemStackFull = ((Slot)object).getItem();
                if (slotItemStackFull == null) {
                    return null;
                }
                return this.getNBT(slotItemStackFull, ObjectType.ITEM_STACK_FULL);
            }
            case ENTITY: {
                Entity entity = (Entity)object;
                if (entity.isDead()) {
                    return null;
                }
                NBTEntity nbtEntity = new NBTEntity(entity);
                return nbtEntity.toString();
            }
            case BLOCK: {
                NBTTileEntity tile = new NBTTileEntity(((Block)object).getState());
                try {
                    return tile.getCompound().toString();
                }
                catch (NbtApiException ignore) {
                    return null;
                }
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unsupported ObjectType: " + (Object)((Object)type));
        }
        return null;
    }

    public ItemType getItemTypeFromNBT(String nbt) {
        if (!this.validateNBT(nbt)) {
            return null;
        }
        return new ItemType(this.getItemStackFromNBT(nbt));
    }

    public ItemStack getItemStackFromNBT(String nbt) {
        if (!this.validateNBT(nbt)) {
            return null;
        }
        NBTContainer container = new NBTContainer(nbt);
        return NBTItem.convertNBTtoItem(container);
    }

    public Object getTag(String tag, String nbt) {
        if (nbt == null) {
            return null;
        }
        NBTContainer compound = new NBTContainer(nbt);
        NBTType type = compound.getType(tag);
        switch (type) {
            case NBTTagString: {
                return compound.getString(tag);
            }
            case NBTTagInt: {
                return compound.getInteger(tag);
            }
            case NBTTagIntArray: {
                UUID uuid = compound.getUUID(tag);
                if (uuid != null) {
                    return uuid;
                }
                return Collections.singletonList(compound.getIntArray(tag));
            }
            case NBTTagFloat: {
                return compound.getFloat(tag);
            }
            case NBTTagShort: {
                return compound.getShort(tag);
            }
            case NBTTagDouble: {
                return compound.getDouble(tag);
            }
            case NBTTagEnd: {
                return null;
            }
            case NBTTagLong: {
                return compound.getLong(tag);
            }
            case NBTTagByte: {
                return compound.getByte(tag);
            }
            case NBTTagByteArray: {
                return compound.getByteArray(tag);
            }
            case NBTTagCompound: {
                return compound.getCompound(tag).toString();
            }
            case NBTTagList: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (NBTCompound comp : compound.getCompoundList(tag)) {
                    list.add(comp.toString());
                }
                list.addAll(compound.getDoubleList(tag));
                list.addAll(compound.getFloatList(tag));
                list.addAll(compound.getIntegerList(tag));
                list.addAll(compound.getStringList(tag));
                list.addAll(compound.getLongList(tag));
                return list;
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unknown tag type, please let the dev know -> type: " + type.toString());
        }
        return null;
    }

    public static enum ObjectType {
        ITEM_TYPE(ItemType.class),
        ITEM_TYPE_FULL(ItemType.class),
        ITEM_STACK(ItemStack.class),
        ITEM_STACK_FULL(ItemStack.class),
        SLOT(Slot.class),
        SLOT_FULL(Slot.class),
        ENTITY(Entity.class),
        BLOCK(Block.class),
        FILE(String.class);

        Class<?> cl;

        private ObjectType(Class<?> classType) {
            this.cl = classType;
        }

        public boolean isAssignableFrom(Object object, boolean debug) {
            if (this.cl.isAssignableFrom(object.getClass())) {
                return true;
            }
            if (debug) {
                throw new IllegalArgumentException("Object is not assignable from ObjectType:\n\tObject: " + object + " = " + object.getClass() + "\n\tObjectType: " + (Object)((Object)this) + "\n\tAssignableFrom: " + this.cl);
            }
            return false;
        }
    }
}

