/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.virtualfurnace.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.virtualfurnace.api.RecipeManager;
import tk.shanebee.bee.api.virtualfurnace.api.recipe.FurnaceRecipe;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

@Name(value="VirtualFurnace - Furnace Recipe")
@Description(value={"Register recipes for virtual furnaces. Alternatively you can just register all vanilla-like recipes foryour virtual furnaces. "})
@Examples(value={"on load:", "\tregister virtual furnace recipe for cooked chicken using raw chicken with cooktime 15 seconds", "on load:", "\tregister all virtual furnace recipes"})
@Since(value="1.3.0")
public class EffFurnaceRecipe
extends Effect {
    private static final RecipeManager RECIPE_MANAGER = SkBee.getPlugin().getVirtualFurnaceAPI().getRecipeManager();
    private Expression<ItemType> ingredient;
    private Expression<ItemType> result;
    private Expression<Timespan> cookTime;
    private boolean vanilla;
    private int type;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vanilla = pattern == 1;
        this.type = parseResult.mark;
        if (!this.vanilla) {
            this.ingredient = exprs[1];
            this.result = exprs[0];
            this.cookTime = exprs[2];
        }
        return true;
    }

    protected void execute(Event event) {
        if (this.vanilla) {
            List<FurnaceRecipe> recipes;
            switch (this.type) {
                default: {
                    recipes = FurnaceRecipe.getVanillaFurnaceRecipes();
                    break;
                }
                case 1: {
                    recipes = FurnaceRecipe.getVanillaSmokingRecipes();
                    break;
                }
                case 2: {
                    recipes = FurnaceRecipe.getVanillaBlastingRecipes();
                }
            }
            for (FurnaceRecipe recipe : recipes) {
                RECIPE_MANAGER.registerFurnaceRecipe(recipe);
            }
        } else {
            Material ing = ((ItemType)this.ingredient.getSingle(event)).getMaterial();
            Material result = ((ItemType)this.result.getSingle(event)).getMaterial();
            int cook = this.cookTime != null ? (int)((Timespan)this.cookTime.getSingle(event)).getTicks_i() : 200;
            String key = "recipe_" + ing.toString() + "_" + result.toString() + "_" + cook;
            FurnaceRecipe recipe = new FurnaceRecipe(Util.getKey(key), ing, result, cook);
            RECIPE_MANAGER.registerFurnaceRecipe(recipe);
        }
    }

    public String toString(@Nullable Event e, boolean d) {
        return "register new virtual furnace recipe using " + this.ingredient.toString(e, d) + " with result " + this.result.toString(e, d) + (this.cookTime != null ? " with cook time " + this.cookTime.toString(e, d) : "");
    }

    static {
        Skript.registerEffect(EffFurnaceRecipe.class, (String[])new String[]{"register virtual furnace recipe for %itemtype% using %itemtype% [with cooktime %-timespan%]", "register all virtual (0\u00a6furnace|1\u00a6smoker|2\u00a6blast furnace) recipes"});
    }
}

