/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.event.Event;

@Name(value="Text Component - New Text Component")
@Description(value={"Create a new text component. Can have hover and click events added to it."})
@Examples(value={"set {_comp::1} to text component from \"hi player \"", "set {_comp::2} to text component of \"hover over me for a special message!\"", "set hover event of {_comp::2} to hover event to show \"OoO look ma I'm hovering!\"", "send component {_comp::*} to player"})
@Since(value="1.5.0")
public class ExprTextComponent
extends SimpleExpression<TextComponent> {
    private Expression<String> strings;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.strings = exprs[0];
        return true;
    }

    @Nullable
    protected TextComponent[] get(Event e) {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        for (String string : (String[])this.strings.getArray(e)) {
            components.add(new TextComponent(string));
        }
        return components.toArray(new TextComponent[0]);
    }

    public boolean isSingle() {
        return this.strings.isSingle();
    }

    public Class<? extends TextComponent> getReturnType() {
        return TextComponent.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "a new text component from " + this.strings.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprTextComponent.class, TextComponent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] text component[s] (from|of) %strings%"});
    }
}

