/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import tk.shanebee.bee.api.NBTApi;

@Name(value="Text Component - Hover Event")
@Description(value={"Create a new hover event. Can show text or an item to a player. I'm not sure which version 'showing item' was introduced on, so if it doesn't work on your version, your version is probably too old."})
@Examples(value={"set {_t} to text component from \"Check out my cool tool!\"", "set hover event of {_t} to a new hover event showing player's tool", "send component {_t} to player"})
@Since(value="1.5.0")
public class ExprHoverEvent
extends SimpleExpression<HoverEvent> {
    private int pattern;
    private Expression<Object> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.object = exprs[0];
        return true;
    }

    @Nullable
    protected HoverEvent[] get(Event e) {
        if (this.object == null) {
            return null;
        }
        if (this.pattern == 0) {
            String[] string = (String[])this.object.getArray(e);
            ArrayList<Text> texts = new ArrayList<Text>();
            for (int i = 0; i < string.length; ++i) {
                texts.add(new Text(string[i] + (i < string.length - 1 ? System.lineSeparator() : "")));
            }
            return new HoverEvent[]{new HoverEvent(HoverEvent.Action.SHOW_TEXT, texts)};
        }
        if (this.pattern == 1) {
            ItemStack itemStack = ((ItemType)this.object.getSingle(e)).getRandom();
            if (itemStack == null) {
                return null;
            }
            String id = "minecraft:" + itemStack.getType().toString().toLowerCase();
            String nbt = new NBTApi().getNBT(itemStack, NBTApi.ObjectType.ITEM_STACK);
            Item item = new Item(id, itemStack.getAmount(), ItemTag.ofNbt((String)nbt));
            return new HoverEvent[]{new HoverEvent(HoverEvent.Action.SHOW_ITEM, new Content[]{item})};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends HoverEvent> getReturnType() {
        return HoverEvent.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "hover event showing " + this.object.toString(e, d);
    }

    static {
        if (Skript.classExists((String)"net.md_5.bungee.api.chat.hover.content.Item")) {
            Skript.registerExpression(ExprHoverEvent.class, HoverEvent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] hover event showing %strings%", "[a] [new] hover event showing %itemtype%"});
        } else {
            Skript.registerExpression(ExprHoverEvent.class, HoverEvent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] hover event showing %strings%"});
        }
    }
}

