/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBTApi;
import tk.shanebee.bee.api.util.Util;

@Name(value="NBT - Tag")
@Description(value={"Returns the value of the specified tag of the specified NBT. Also supports getting nested tags using a semi colon as a delimiter. If the return value is a list, you can use it as a list, as it will automatically split it for ya. (Currently only supports get. Set may be available in the future)"})
@Examples(value={"set {_tag} to tag \"Invulnerable\" of targeted entity's nbt", "send \"Tag: %tag \"\"CustomName\"\" of nbt of target entity%\" to player", "set {_tag} to \"Enchantments\" tag of nbt of player's tool", "set {_tag} to \"BlockEntityTag;Items\" tag of nbt of target block"})
@Since(value="1.0.0")
public class ExprTagOfNBT
extends SimpleExpression<Object> {
    private static final NBTApi NBT_API;
    private static final boolean DEBUG;
    private Expression<String> a;
    private Expression<String> b;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.a = expressions[0];
        this.b = expressions[1];
        return true;
    }

    @Nullable
    protected Object[] get(Event e) {
        String t = (String)this.a.getSingle(e);
        String n = (String)this.b.getSingle(e);
        if (t.contains(";")) {
            return this.getNested(t, n);
        }
        Object nbt = NBT_API.getTag(t, n);
        if (nbt instanceof ArrayList) {
            return ((ArrayList)nbt).toArray();
        }
        return new Object[]{nbt};
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "Tag \"" + this.a.toString(e, d) + "\" of " + this.b.toString(e, d);
    }

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    private Object[] getNested(String tag, String nbt) {
        String[] split = tag.split(";");
        Object nbtNew = nbt;
        for (String s : split) {
            NBTContainer container = new NBTContainer(nbtNew.toString());
            if ((nbtNew = NBT_API.getTag(s, container.toString())) != null) continue;
            if (DEBUG) {
                Util.skriptError("Invalid tag \"&b" + s + "&7\" in &b" + container.toString());
            }
            return null;
        }
        if (nbtNew instanceof ArrayList) {
            return ((ArrayList)nbtNew).toArray();
        }
        return new Object[]{nbtNew};
    }

    static {
        Skript.registerExpression(ExprTagOfNBT.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"tag %string% of %string%", "%string% tag of %string%"});
        NBT_API = SkBee.getPlugin().getNbtApi();
        DEBUG = SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG;
    }
}

