/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.config;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import tk.shanebee.bee.SkBee;

public class Config {
    private final SkBee plugin;
    private FileConfiguration config;
    private File configFile;
    public boolean SETTINGS_DEBUG;
    public boolean ELEMENTS_NBT;
    public boolean ELEMENTS_BOARD;
    public boolean ELEMENTS_RECIPE;
    public boolean ELEMENTS_BOUND;
    public boolean ELEMENTS_STRUCTURE;
    public boolean ELEMENTS_VIRTUAL_FURNACE;
    public String RECIPE_NAMESPACE;

    public Config(SkBee plugin) {
        this.plugin = plugin;
        this.loadConfigFile();
    }

    private void loadConfigFile() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.matchConfig();
        this.loadConfigs();
    }

    private void matchConfig() {
        try {
            boolean hasUpdated = false;
            InputStream stream = this.plugin.getResource(this.configFile.getName());
            assert (stream != null);
            InputStreamReader is = new InputStreamReader(stream);
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)is);
            for (String key : defConfig.getConfigurationSection("").getKeys(true)) {
                if (this.config.contains(key)) continue;
                this.config.set(key, defConfig.get(key));
                hasUpdated = true;
            }
            for (String key : this.config.getConfigurationSection("").getKeys(true)) {
                if (defConfig.contains(key)) continue;
                this.config.set(key, null);
                hasUpdated = true;
            }
            if (hasUpdated) {
                this.config.save(this.configFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadConfigs() {
        this.SETTINGS_DEBUG = this.config.getBoolean("settings.debug");
        this.ELEMENTS_NBT = this.config.getBoolean("elements.nbt");
        this.ELEMENTS_BOARD = this.config.getBoolean("elements.scoreboard");
        this.ELEMENTS_RECIPE = this.config.getBoolean("elements.recipe");
        this.ELEMENTS_BOUND = this.config.getBoolean("elements.bound");
        this.ELEMENTS_STRUCTURE = this.config.getBoolean("elements.structure");
        this.ELEMENTS_VIRTUAL_FURNACE = this.config.getBoolean("elements.virtual-furnace");
        String namespace = this.config.getString("recipe.namespace");
        if (namespace == null) {
            namespace = "skrecipe";
        }
        this.RECIPE_NAMESPACE = namespace.toLowerCase();
    }
}

