/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;

@Name(value="Block Data - Block")
@Description(value={"Get block data from a block. You can get a string of block data, all the tags in a block data or a specific tag. ", "You can also set a block data for a block or set a specific tag for block data. This syntax is only available for MC 1.13+"})
@Examples(value={"set {_data} to block data of target block of player", "set {_data::*} to block data tags of target block of player", "set {_water} to block data tag \"waterlogged\" of event-block", "set block data of target block to \"minecraft:carrots[age=7]\"", "set block data tag \"waterlogged\" of event-block to true"})
@Since(value="1.0.0")
public class ExprBlockDataBlock
extends SimpleExpression<Object> {
    private Expression<String> tag;
    private Expression<Block> blocks;
    private int parse;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.tag = exprs[0];
        this.blocks = exprs[1];
        this.parse = parseResult.mark;
        return true;
    }

    protected Object[] get(Event event) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Block block : (Block[])this.blocks.getAll(event)) {
            if (this.parse == 2) {
                String tag = this.getTag(block.getBlockData().getAsString(), (String)this.tag.getSingle(event));
                if (tag == null) {
                    return null;
                }
                if (this.isBoolean(tag)) {
                    list.add(Boolean.valueOf(tag));
                    continue;
                }
                if (this.isNumber(tag)) {
                    list.add(Integer.parseInt(tag));
                    continue;
                }
                list.add(tag);
                continue;
            }
            if (this.parse == 1) {
                String[] data = this.getData(block.getBlockData().getAsString());
                if (data == null) continue;
                list.addAll(Arrays.asList(data));
                continue;
            }
            list.add(block.getBlockData().getAsString());
        }
        return list.toArray();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String obj = delta == null ? "" : delta[0].toString();
        block8: for (Block block : (Block[])this.blocks.getAll(e)) {
            switch (this.parse) {
                case 2: {
                    BlockData blockData;
                    String newData = block.getType().getKey() + "[" + (String)this.tag.getSingle(e) + "=" + obj + "]";
                    try {
                        blockData = Bukkit.createBlockData((String)newData);
                        BlockData oldData = block.getBlockData();
                        blockData = oldData.merge(blockData);
                        block.setBlockData(blockData);
                    }
                    catch (IllegalArgumentException ex) {
                        Skript.error((String)("Could not parse block data: " + newData), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    }
                    continue block8;
                }
                case 1: {
                    return;
                }
                default: {
                    BlockData blockData;
                    try {
                        blockData = Bukkit.createBlockData((String)obj);
                        block.setBlockData(blockData, this.parse != 3);
                        continue block8;
                    }
                    catch (IllegalArgumentException ex) {
                        Skript.error((String)("Could not parse block data: " + obj), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    }
                }
            }
        }
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public boolean isSingle() {
        return this.parse != 1;
    }

    public String toString(Event e, boolean d) {
        return "block data" + (this.parse == 1 ? " tags" : (this.parse == 2 ? " tag " + this.tag.toString(e, d) : "")) + " of block " + this.blocks.toString(e, d);
    }

    private String getTag(String data, String tag) {
        String[] sp = this.getData(data);
        if (sp != null) {
            for (String string : sp) {
                String[] s = string.split("=");
                if (!s[0].equals(tag)) continue;
                return s[1];
            }
        }
        return null;
    }

    private String[] getData(String data) {
        String[] splits1 = data.split("\\[");
        if (splits1.length >= 2) {
            String[] splits2 = splits1[1].split("]");
            return splits2[0].split(",");
        }
        return null;
    }

    private boolean isNumber(String string) {
        return string.matches("\\d+");
    }

    private boolean isBoolean(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false");
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            PropertyExpression.register(ExprBlockDataBlock.class, Object.class, (String)"block[ ](data|state) [(1\u00a6tags|2\u00a6tag %-string%|3\u00a6without update[s])]", (String)"blocks");
        }
    }
}

