/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import tk.shanebee.bee.api.virtualfurnace.api.recipe.Fuel;
import tk.shanebee.bee.api.virtualfurnace.api.recipe.FurnaceRecipe;

public class RecipeManager {
    private final Map<NamespacedKey, Fuel> fuelMap = new HashMap<NamespacedKey, Fuel>();
    private final Map<NamespacedKey, FurnaceRecipe> furnaceRecipeMap = new HashMap<NamespacedKey, FurnaceRecipe>();

    RecipeManager() {
    }

    public boolean registerFuel(Fuel fuel) {
        if (this.fuelMap.containsKey(fuel.getKey())) {
            return false;
        }
        this.fuelMap.put(fuel.getKey(), fuel);
        return true;
    }

    public boolean registerFurnaceRecipe(FurnaceRecipe furnaceRecipe) {
        if (this.furnaceRecipeMap.containsKey(furnaceRecipe.getKey())) {
            return false;
        }
        this.furnaceRecipeMap.put(furnaceRecipe.getKey(), furnaceRecipe);
        return true;
    }

    public Map<NamespacedKey, Fuel> getFuels() {
        return this.fuelMap;
    }

    public Map<NamespacedKey, FurnaceRecipe> getFurnaceRecipes() {
        return this.furnaceRecipeMap;
    }

    public Fuel getFuelByMaterial(Material material) {
        for (Fuel fuel : this.fuelMap.values()) {
            if (!fuel.matchFuel(material)) continue;
            return fuel;
        }
        return null;
    }

    public Fuel getFuelByKey(NamespacedKey key) {
        return this.fuelMap.get(key);
    }

    public FurnaceRecipe getByIngredient(Material ingredient) {
        for (FurnaceRecipe recipe : this.furnaceRecipeMap.values()) {
            if (recipe.getIngredient() != ingredient) continue;
            return recipe;
        }
        return null;
    }

    public FurnaceRecipe getFurnaceRecipeByKey(NamespacedKey key) {
        return this.furnaceRecipeMap.get(key);
    }
}

