/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Armor Change Event - Item")
@Description(value={"Get the old/new item in an armor change event. Defaults to new. When using set, it will set the slot that was changed, old/new will make no difference in this case. Requires Paper 1.12.2+"})
@Examples(value={"on player armor change:", "\tif new armor item is any helmet:", "\t\tset armor item to a diamond helmet"})
@Since(value="1.3.1")
public class ExprArmorChange
extends SimpleExpression<ItemType> {
    private boolean old;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(PlayerArmorChangeEvent.class)) {
            Skript.error((String)"The expression 'armor item' can only be used in an armor change event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.old = parseResult.mark == 1;
        return true;
    }

    @Nullable
    protected ItemType[] get(Event e) {
        ItemType[] itemTypeArray;
        ItemStack item = this.old ? ((PlayerArmorChangeEvent)e).getOldItem() : ((PlayerArmorChangeEvent)e).getNewItem();
        if (item != null) {
            ItemType[] itemTypeArray2 = new ItemType[1];
            itemTypeArray = itemTypeArray2;
            itemTypeArray2[0] = new ItemType(item);
        } else {
            itemTypeArray = null;
        }
        return itemTypeArray;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType[].class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType item;
        ItemType itemType = item = delta instanceof ItemType[] ? ((ItemType[])delta)[0] : null;
        if (item == null) {
            return;
        }
        ItemStack itemStack = item.getRandom();
        PlayerInventory playerInv = ((PlayerArmorChangeEvent)e).getPlayer().getInventory();
        PlayerArmorChangeEvent.SlotType type = ((PlayerArmorChangeEvent)e).getSlotType();
        if (type == PlayerArmorChangeEvent.SlotType.HEAD) {
            playerInv.setHelmet(itemStack);
        } else if (type == PlayerArmorChangeEvent.SlotType.CHEST) {
            playerInv.setChestplate(itemStack);
        } else if (type == PlayerArmorChangeEvent.SlotType.LEGS) {
            playerInv.setLeggings(itemStack);
        } else if (type == PlayerArmorChangeEvent.SlotType.FEET) {
            playerInv.setBoots(itemStack);
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return (this.old ? "old" : "new") + " armor item";
    }

    static {
        if (Skript.classExists((String)"com.destroystokyo.paper.event.player.PlayerArmorChangeEvent")) {
            Skript.registerExpression(ExprArmorChange.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(0\u00a6new|1\u00a6old)] armor item"});
        }
    }
}

