/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api;

import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import tk.shanebee.bee.api.virtualfurnace.api.FurnaceManager;
import tk.shanebee.bee.api.virtualfurnace.api.RecipeManager;
import tk.shanebee.bee.api.virtualfurnace.api.TileManager;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.api.virtualfurnace.api.chunk.VirtualChunk;
import tk.shanebee.bee.api.virtualfurnace.api.event.machine.FurnaceExtractEvent;
import tk.shanebee.bee.api.virtualfurnace.api.machine.Furnace;
import tk.shanebee.bee.api.virtualfurnace.api.recipe.Fuel;
import tk.shanebee.bee.api.virtualfurnace.api.tile.Tile;

class FurnaceListener
implements Listener {
    private final FurnaceManager furnaceManager;
    private final RecipeManager recipeManager;
    private final TileManager tileManager;

    FurnaceListener(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.furnaceManager = virtualFurnaceAPI.getFurnaceManager();
        this.recipeManager = virtualFurnaceAPI.getRecipeManager();
        this.tileManager = virtualFurnaceAPI.getTileManager();
    }

    @EventHandler
    private void onClickFurnace(PlayerInteractEvent event) {
        Tile<?> tile;
        Furnace furnace;
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack hand = event.getItem();
        if (hand != null && (furnace = this.furnaceManager.getFurnaceFromItemStack(hand)) != null) {
            event.setCancelled(true);
            furnace.openInventory(event.getPlayer());
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Chunk chunk = block.getChunk();
        VirtualChunk virtualChunk = this.tileManager.getChunk(chunk);
        if (virtualChunk != null && (tile = virtualChunk.getTile(block)) != null) {
            event.setCancelled(true);
            if (event.getHand() != EquipmentSlot.OFF_HAND) {
                tile.activate(event.getPlayer());
            }
        }
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        HumanEntity clicker = event.getWhoClicked();
        if (holder instanceof Furnace && clicker instanceof Player) {
            ItemStack cursor;
            Fuel fuel;
            Furnace furnace = (Furnace)holder;
            int slot = event.getRawSlot();
            if (slot == 2) {
                ItemStack output = furnace.getOutput();
                if (output != null) {
                    int exp = (int)furnace.extractExperience();
                    FurnaceExtractEvent extractEvent = new FurnaceExtractEvent(furnace, (Player)clicker, output, exp);
                    extractEvent.callEvent();
                    ((Player)clicker).giveExp(extractEvent.getExperience());
                    event.setCurrentItem(extractEvent.getItemStack());
                }
            } else if (slot == 1 && (fuel = this.recipeManager.getFuelByMaterial((cursor = clicker.getItemOnCursor()).getType())) != null && this.isNotVanillaFuel(cursor)) {
                ItemStack furnaceFuel = furnace.getFuel();
                event.setCancelled(true);
                if (furnaceFuel != null && furnaceFuel.getType() == cursor.getType()) {
                    InventoryView view = event.getView();
                    int fuelAmount = furnaceFuel.getAmount();
                    int cursorAmount = cursor.getAmount();
                    int maxStack = cursor.getType().getMaxStackSize();
                    ItemStack fuelSlot = view.getItem(1);
                    assert (fuelSlot != null);
                    if (fuelAmount < maxStack) {
                        int diff = maxStack - fuelAmount;
                        if (cursorAmount < diff) {
                            cursor.setAmount(0);
                            fuelSlot.setAmount(fuelAmount + cursorAmount);
                        } else {
                            cursor.setAmount(cursorAmount - diff);
                            fuelSlot.setAmount(maxStack);
                        }
                        ((Player)clicker).updateInventory();
                    }
                } else {
                    ItemStack oldCursor = cursor.clone();
                    clicker.setItemOnCursor(furnaceFuel);
                    event.getView().setItem(1, oldCursor);
                }
            }
        }
    }

    private boolean isNotVanillaFuel(ItemStack itemStack) {
        for (Fuel fuel : Fuel.getVanillaFuels()) {
            if (fuel.getFuel() != itemStack.getType()) continue;
            return false;
        }
        return true;
    }

    @EventHandler
    private void onChunkLoad(ChunkLoadEvent event) {
        this.handleChunk(event.getChunk(), true);
    }

    @EventHandler
    private void onChunkUnload(ChunkUnloadEvent event) {
        this.handleChunk(event.getChunk(), false);
    }

    private void handleChunk(Chunk chunk, boolean load) {
        VirtualChunk virtualChunk = this.tileManager.getChunk(chunk);
        if (virtualChunk != null) {
            if (load) {
                if (virtualChunk.isLoaded()) {
                    return;
                }
                this.tileManager.loadChunk(virtualChunk);
            } else {
                if (virtualChunk.isForceLoaded()) {
                    return;
                }
                this.tileManager.unloadChunk(virtualChunk);
            }
        }
    }
}

