/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.util;

import ch.njol.skript.Skript;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.util.Util;

public class RecipeUtil {
    private static final String NAMESPACE = SkBee.getPlugin().getPluginConfig().RECIPE_NAMESPACE;
    private static final boolean BUKKIT_REMOVE = Skript.methodExists(Bukkit.class, (String)"removeRecipe", (Class[])new Class[]{NamespacedKey.class}, Boolean.class);

    public static NamespacedKey getKey(String key) {
        return new NamespacedKey(NAMESPACE, key.toLowerCase());
    }

    private static NamespacedKey getKeyByPlugin(String key) {
        if (key.contains(":")) {
            String[] split = key.split(":");
            return new NamespacedKey(split[0], split[1]);
        }
        return null;
    }

    public static NamespacedKey getKeyFromString(String key) {
        if (key.contains(":")) {
            String[] split = key.toLowerCase().split(":");
            if (split[0].equalsIgnoreCase("minecraft")) {
                return NamespacedKey.minecraft((String)split[1]);
            }
            return RecipeUtil.getKeyByPlugin(key);
        }
        return RecipeUtil.getKey(key);
    }

    public static void removeRecipeByKey(String recipe) {
        if ((recipe = recipe.toLowerCase()).contains("minecraft:")) {
            RecipeUtil.removeMCRecipe(recipe);
        } else if (recipe.contains(NAMESPACE + ":")) {
            recipe = recipe.split(":")[1];
            RecipeUtil.removeRecipeByKey(RecipeUtil.getKey(recipe));
        } else if (recipe.contains(":")) {
            NamespacedKey key = RecipeUtil.getKeyByPlugin(recipe);
            if (key != null) {
                RecipeUtil.removeRecipeByKey(key);
            }
        } else {
            RecipeUtil.removeRecipeByKey(RecipeUtil.getKey(recipe));
        }
    }

    public static void removeMCRecipe(String recipe) {
        recipe = recipe.replace("minecraft:", "");
        RecipeUtil.removeRecipeByKey(NamespacedKey.minecraft((String)recipe));
    }

    public static void removeRecipeByKey(NamespacedKey recipeKey) {
        if (BUKKIT_REMOVE) {
            Bukkit.removeRecipe((NamespacedKey)recipeKey);
        } else {
            ArrayList recipes = new ArrayList();
            Bukkit.recipeIterator().forEachRemaining(recipe -> {
                if (recipe instanceof Keyed && !((Keyed)recipe).getKey().equals((Object)recipeKey)) {
                    recipes.add(recipe);
                }
            });
            Bukkit.clearRecipes();
            recipes.forEach(Bukkit::addRecipe);
        }
    }

    public static void removeAllMCRecipes() {
        ArrayList recipes = new ArrayList();
        Bukkit.recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof Keyed && !((Keyed)recipe).getKey().getNamespace().equalsIgnoreCase("minecraft")) {
                recipes.add(recipe);
            }
        });
        Bukkit.clearRecipes();
        recipes.forEach(Bukkit::addRecipe);
    }

    public static void logRecipe(Recipe recipe, String ingredients) {
        String name = "";
        if (recipe instanceof Keyed) {
            name = "&7(&b" + ((Keyed)recipe).getKey().toString() + "&7)";
        }
        RecipeUtil.log("&aRegistered new recipe: " + name);
        RecipeUtil.log(" - &7Result: " + recipe.getResult());
        RecipeUtil.log(" - &7Ingredients: " + ingredients);
    }

    public static void error(String error) {
        RecipeUtil.log("&c" + error);
    }

    public static void warn(String warning) {
        RecipeUtil.log("&e" + warning);
    }

    public static void log(String log) {
        String prefix = "&7[&bRecipe&7] ";
        Util.log(prefix + log);
    }
}

