/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.EffSpawn;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Consumer;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBTApi;

@Name(value="NBT - Spawn Entity with NBT")
@Description(value={"Spawn an entity at a location with NBT"})
@Examples(value={"spawn sheep at player with nbt \"{NoAI:1b}\"", "spawn 1 of zombie at player with nbt \"{NoGravity:1b}\""})
@Since(value="1.0.0")
public class EffSpawnEntityNBT
extends Effect {
    private static final NBTApi NBT_API;
    private Expression<Location> locations;
    private Expression<EntityType> types;
    private Expression<String> nbtString;
    @Nullable
    private Expression<Number> amount;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.amount = matchedPattern == 0 ? null : exprs[0];
        this.types = exprs[matchedPattern];
        this.locations = Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        this.nbtString = exprs[3 + matchedPattern];
        return true;
    }

    public void execute(Event e) {
        Integer a;
        String value = (String)this.nbtString.getSingle(e);
        Number number = a = this.amount != null ? (Number)((Number)this.amount.getSingle(e)) : (Number)1;
        if (a == null) {
            return;
        }
        EntityType[] et = (EntityType[])this.types.getArray(e);
        for (Location loc : (Location[])this.locations.getArray(e)) {
            assert (loc != null) : this.locations;
            for (EntityType type : et) {
                int i = 0;
                while ((double)i < ((Number)a).doubleValue() * (double)type.getAmount()) {
                    EffSpawn.lastSpawned = this.spawn(loc, type.data.getType(), value);
                    ++i;
                }
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "spawn " + (this.amount != null ? this.amount.toString(e, debug) + " " : "") + this.types.toString(e, debug) + " " + this.locations.toString(e, debug) + " " + this.nbtString.toString(e, debug);
    }

    private <T extends Entity> Entity spawn(Location loc, Class<T> type, String nbt) {
        if (Skript.methodExists(World.class, (String)"spawn", (Class[])new Class[]{Location.class, Class.class, Consumer.class})) {
            Skript.warning((String)"Testing with consumer");
            return loc.getWorld().spawn(loc, type, ent -> NBT_API.addNBT((Entity)ent, nbt));
        }
        Skript.error((String)"No consumer");
        Entity e = loc.getWorld().spawn(loc, type);
        NBT_API.addNBT(e, nbt);
        return e;
    }

    static {
        Skript.registerEffect(EffSpawnEntityNBT.class, (String[])new String[]{"spawn %entitytypes% [%directions% %locations%] with nbt %string%", "spawn %number% of %entitytypes% [%directions% %locations%] with nbt %string%"});
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

