/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.board.objects;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.util.Validate;

public class Board {
    private static final Map<Player, Board> BOARD_MAP = new HashMap<Player, Board>();
    private final SkBee plugin = SkBee.getPlugin();
    private final Player player;
    private final Scoreboard scoreboard;
    private final Objective board;
    private final Team[] lines = new Team[15];
    private final String[] entries = new String[]{"&1", "&2", "&3", "&4", "&5", "&6", "&7", "&9", "&9", "&0", "&a", "&b", "&c", "&d", "&e"};
    private boolean on;

    public static Board getBoard(Player player) {
        return BOARD_MAP.get(player);
    }

    public static void createBoard(Player player) {
        Board board = new Board(player, false);
        BOARD_MAP.put(player, board);
    }

    public static void removeBoard(Player player) {
        if (BOARD_MAP.containsKey(player)) {
            BOARD_MAP.get(player).clearBoard();
        }
        BOARD_MAP.remove(player);
    }

    public static void clearBoards() {
        for (Board board : BOARD_MAP.values()) {
            board.clearBoard();
        }
        BOARD_MAP.clear();
    }

    public Board(Player player, boolean load) {
        this.player = player;
        this.on = true;
        if (!load) {
            int i;
            this.scoreboard = this.plugin.getServer().getScoreboardManager().getNewScoreboard();
            this.player.setScoreboard(this.scoreboard);
            this.board = this.scoreboard.registerNewObjective("Board", "dummy", "Board");
            this.board.setDisplaySlot(DisplaySlot.SIDEBAR);
            this.board.setDisplayName(" ");
            for (i = 0; i < 15; ++i) {
                this.lines[i] = this.scoreboard.registerNewTeam("line" + (i + 1));
            }
            for (i = 0; i < 15; ++i) {
                this.lines[i].addEntry(this.getColString(this.entries[i]));
            }
        } else {
            this.scoreboard = player.getScoreboard();
            this.board = this.scoreboard.getObjective("Board");
            for (int i = 0; i < 15; ++i) {
                this.lines[i] = this.scoreboard.getTeam("line" + (i + 1));
            }
        }
    }

    public void setTitle(String title) {
        this.board.setDisplayName(this.getColString(title));
    }

    public void setLine(int line, String text) {
        Validate.isBetween(line, 1, 15);
        Team t = this.lines[line - 1];
        t.setPrefix(this.getColString(text));
        this.board.getScore(this.getColString(this.entries[line - 1])).setScore(line);
    }

    public void deleteLine(int line) {
        Validate.isBetween(line, 1, 15);
        this.scoreboard.resetScores(this.getColString(this.entries[line - 1]));
    }

    public void clearBoard() {
        for (int i = 1; i < 16; ++i) {
            this.deleteLine(i);
        }
    }

    public void toggle(boolean on) {
        if (on) {
            this.player.setScoreboard(this.scoreboard);
            this.on = true;
        } else {
            this.player.setScoreboard(this.plugin.getServer().getScoreboardManager().getNewScoreboard());
            this.on = false;
        }
    }

    public boolean isOn() {
        return this.on;
    }

    private String getColString(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

