/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.nbt.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBTApi;

@Name(value="NBT - Item/Inventory Slot/Entity/Block/File")
@Description(value={"NBT of items, inventory slots, entities, tile entities (such as a furnace, hopper, brewing stand, banner, etc) or files. ", "Supports get, set, add and reset. Reset will only properly work on an item, not entities or blocks. ", "Set should not be used on entities or blocks, it's best to use add. Using set can quite often screw up the entity/block's location. ", "The optional 'full' part (added in 1.4.10) will only work on items/slots. When using this, it will return the full NBT of said item, ", "including the item amount as well as the item type."})
@Examples(value={"set {_nbt} to nbt of player's tool", "set {_f} to full nbt of player's tool", "add \"{Enchantments:[{id:\"\"sharpness\"\",lvl:5}]}\" to nbt of player's tool", "reset nbt of player's tool", "set {_nbt} to nbt of target entity", "set {_nbt} to event-entity", "add \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&bMyNewName\\\"\"}\"\"}\" to nbt of target entity", "add \"{RequiredPlayerRange:0s}\" to targeted block's nbt", "add \"{SpawnData:{id:\"\"minecraft:wither\"\"}}\" to nbt of clicked block", "set {_nbt} to file-nbt of \"world/playerdata/some-uuid-here.dat\""})
@Since(value="1.0.0")
public class ExprObjectNBT
extends SimplePropertyExpression<Object, String> {
    private static final NBTApi NBT_API;
    private boolean full;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.full = parseResult.mark == 1;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public String convert(Object o) {
        if (o instanceof Slot) {
            return this.full ? NBT_API.getFullNBT((Slot)o) : NBT_API.getNBT((Slot)o);
        }
        if (o instanceof ItemStack) {
            return this.full ? NBT_API.getFullNBT((ItemStack)o) : NBT_API.getNBT((ItemStack)o);
        }
        if (o instanceof ItemType) {
            return this.full ? NBT_API.getFullNBT((ItemType)o) : NBT_API.getNBT((ItemType)o);
        }
        if (o instanceof Entity) {
            return NBT_API.getNBT((Entity)o);
        }
        if (o instanceof Block) {
            return NBT_API.getNBT((Block)o);
        }
        if (o instanceof String) {
            return NBT_API.getNBT((String)o);
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String value;
        Object o = this.getExpr().getSingle(event);
        String string = value = delta != null ? (String)delta[0] : "{}";
        if (!NBT_API.validateNBT(value)) {
            return;
        }
        switch (mode) {
            case ADD: {
                if (o instanceof Slot) {
                    NBT_API.addNBT((Slot)o, value);
                    break;
                }
                if (o instanceof ItemStack) {
                    NBT_API.addNBT((ItemStack)o, value);
                    break;
                }
                if (o instanceof ItemType) {
                    NBT_API.addNBT((ItemType)o, value);
                    break;
                }
                if (o instanceof Entity) {
                    NBT_API.addNBT((Entity)o, value);
                    break;
                }
                if (o instanceof Block) {
                    NBT_API.addNBT((Block)o, value);
                    break;
                }
                if (!(o instanceof String)) break;
                NBT_API.addNBT((String)o, value);
                break;
            }
            case SET: 
            case RESET: {
                if (o instanceof Slot) {
                    NBT_API.setNBT((Slot)o, value);
                    break;
                }
                if (o instanceof ItemStack) {
                    NBT_API.setNBT((ItemStack)o, value);
                    break;
                }
                if (o instanceof ItemType) {
                    NBT_API.setNBT((ItemType)o, value);
                    break;
                }
                if (o instanceof Entity) {
                    NBT_API.setNBT((Entity)o, value);
                    break;
                }
                if (o instanceof Block) {
                    NBT_API.setNBT((Block)o, value);
                    break;
                }
                if (!(o instanceof String)) break;
                NBT_API.setNBT((String)o, value);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    protected String getPropertyName() {
        return "object nbt";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprObjectNBT.register(ExprObjectNBT.class, String.class, (String)"[(1\u00a6full )][(entity|item|slot|block|tile[(-| )]entity|file)(-| )]nbt", (String)"block/entity/itemstack/itemtype/slot/string");
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

