/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.NBT;

import org.bukkit.block.BlockState;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTReflectionUtil;
import tk.shanebee.bee.api.NBT.utils.MinecraftVersion;
import tk.shanebee.bee.api.NBT.utils.annotations.AvaliableSince;
import tk.shanebee.bee.api.NBT.utils.annotations.CheckUtil;
import tk.shanebee.bee.api.NBT.utils.annotations.FAUtil;

public class NBTTileEntity
extends NBTCompound {
    private final BlockState tile;

    public NBTTileEntity(BlockState tile) {
        super(null, null);
        if (tile == null || !tile.isPlaced()) {
            throw new NullPointerException("Tile can't be null/not placed!");
        }
        this.tile = tile;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getTileEntityNBTTagCompound(this.tile);
    }

    @Override
    protected void setCompound(Object compound) {
        NBTReflectionUtil.setTileEntityNBTTagCompound(this.tile, compound);
    }

    @AvaliableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("PublicBukkitValues").booleanValue()) {
            return this.getCompound("PublicBukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("PublicBukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("PublicBukkitValues");
    }
}

