/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.event.Event;

@Name(value="EntityBlockStorage - Entity Count")
@Description(value={"Get the amount of entities currently stored in a storage block.", "As of 1.15 this only includes beehives/bee nests! Requires Spigot/Paper 1.15.2+"})
@Examples(value={"if amount of stored entities in block at player > 10:", "set {_a} to size of entities stored in event-block"})
@Since(value="1.0.0")
public class ExprEntityBlockStorageCount
extends PropertyExpression<Block, Long> {
    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Long[] get(Event event, Block[] blocks) {
        return (Long[])this.get(blocks, block -> {
            BlockState state = block.getState();
            if (state instanceof EntityBlockStorage) {
                return ((EntityBlockStorage)state).getEntityCount();
            }
            return 0L;
        });
    }

    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    public String toString(Event e, boolean d) {
        return "amount of entities stored in " + this.getExpr().toString(e, d);
    }

    static {
        if (Skript.classExists((String)"org.bukkit.block.EntityBlockStorage")) {
            Skript.registerExpression(ExprEntityBlockStorageCount.class, Long.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(size|amount) of [all] (stored entities|entities stored) in %blocks%"});
        }
    }
}

