/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.NBT;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Set;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTCompoundList;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTDoubleList;
import tk.shanebee.bee.api.NBT.NBTFloatList;
import tk.shanebee.bee.api.NBT.NBTIntegerList;
import tk.shanebee.bee.api.NBT.NBTList;
import tk.shanebee.bee.api.NBT.NBTListCompound;
import tk.shanebee.bee.api.NBT.NBTLongList;
import tk.shanebee.bee.api.NBT.NBTStringList;
import tk.shanebee.bee.api.NBT.NBTType;
import tk.shanebee.bee.api.NBT.NbtApiException;
import tk.shanebee.bee.api.NBT.utils.GsonWrapper;
import tk.shanebee.bee.api.NBT.utils.MinecraftVersion;
import tk.shanebee.bee.api.NBT.utils.nmsmappings.ClassWrapper;
import tk.shanebee.bee.api.NBT.utils.nmsmappings.ObjectCreator;
import tk.shanebee.bee.api.NBT.utils.nmsmappings.ReflectionMethod;

public class NBTReflectionUtil {
    private NBTReflectionUtil() {
    }

    public static Object getNMSEntity(Entity entity) {
        try {
            return ReflectionMethod.CRAFT_ENTITY_GET_HANDLE.run(ClassWrapper.CRAFT_ENTITY.getClazz().cast(entity), new Object[0]);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting the NMS Entity from a Bukkit Entity!", e);
        }
    }

    public static Object readNBT(InputStream stream) {
        try {
            return ReflectionMethod.NBTFILE_READ.run(null, stream);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while reading a NBT File!", e);
        }
    }

    public static Object writeNBT(Object nbt, OutputStream stream) {
        try {
            return ReflectionMethod.NBTFILE_WRITE.run(null, nbt, stream);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while writing NBT!", e);
        }
    }

    public static void writeApiNBT(NBTCompound comp, OutputStream stream) {
        try {
            Object nbttag = comp.getCompound();
            if (nbttag == null) {
                nbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            }
            if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
                return;
            }
            Object workingtag = NBTReflectionUtil.gettoCompount(nbttag, comp);
            ReflectionMethod.NBTFILE_WRITE.run(null, workingtag, stream);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while writing NBT!", e);
        }
    }

    public static Object getItemRootNBTTagCompound(Object nmsitem) {
        try {
            Object answer = ReflectionMethod.NMSITEM_GETTAG.run(nmsitem, new Object[0]);
            return answer != null ? answer : ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting an Itemstack's NBTCompound!", e);
        }
    }

    public static Object convertNBTCompoundtoNMSItem(NBTCompound nbtcompound) {
        try {
            Object nmsComp = NBTReflectionUtil.gettoCompount(nbtcompound.getCompound(), nbtcompound);
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_11_R1.getVersionId()) {
                return ObjectCreator.NMS_COMPOUNDFROMITEM.getInstance(nmsComp);
            }
            return ReflectionMethod.NMSITEM_CREATESTACK.run(null, nmsComp);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while converting NBTCompound to NMS ItemStack!", e);
        }
    }

    public static NBTContainer convertNMSItemtoNBTCompound(Object nmsitem) {
        try {
            Object answer = ReflectionMethod.NMSITEM_SAVE.run(nmsitem, ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]));
            return new NBTContainer(answer);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while converting NMS ItemStack to NBTCompound!", e);
        }
    }

    public static Object getEntityNBTTagCompound(Object nmsEntity) {
        try {
            Object nbt = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            Object answer = ReflectionMethod.NMS_ENTITY_GET_NBT.run(nmsEntity, nbt);
            if (answer == null) {
                answer = nbt;
            }
            return answer;
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting NBTCompound from NMS Entity!", e);
        }
    }

    public static Object setEntityNBTTag(Object nbtTag, Object nmsEntity) {
        try {
            ReflectionMethod.NMS_ENTITY_SET_NBT.run(nmsEntity, nbtTag);
            return nmsEntity;
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while setting the NBTCompound of an Entity", ex);
        }
    }

    public static Object getTileEntityNBTTagCompound(BlockState tile) {
        try {
            Object pos = ObjectCreator.NMS_BLOCKPOSITION.getInstance(tile.getX(), tile.getY(), tile.getZ());
            Object cworld = ClassWrapper.CRAFT_WORLD.getClazz().cast(tile.getWorld());
            Object nmsworld = ReflectionMethod.CRAFT_WORLD_GET_HANDLE.run(cworld, new Object[0]);
            Object o = ReflectionMethod.NMS_WORLD_GET_TILEENTITY.run(nmsworld, pos);
            Object tag = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            Object answer = ReflectionMethod.TILEENTITY_GET_NBT.run(o, tag);
            if (answer == null) {
                answer = tag;
            }
            return answer;
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting NBTCompound from TileEntity!", e);
        }
    }

    public static void setTileEntityNBTTagCompound(BlockState tile, Object comp) {
        try {
            Object pos = ObjectCreator.NMS_BLOCKPOSITION.getInstance(tile.getX(), tile.getY(), tile.getZ());
            Object cworld = ClassWrapper.CRAFT_WORLD.getClazz().cast(tile.getWorld());
            Object nmsworld = ReflectionMethod.CRAFT_WORLD_GET_HANDLE.run(cworld, new Object[0]);
            Object o = ReflectionMethod.NMS_WORLD_GET_TILEENTITY.run(nmsworld, pos);
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_16_R1.getVersionId()) {
                Object blockData = ReflectionMethod.TILEENTITY_GET_BLOCKDATA.run(o, new Object[0]);
                ReflectionMethod.TILEENTITY_SET_NBT.run(o, blockData, comp);
            } else {
                ReflectionMethod.TILEENTITY_SET_NBT_LEGACY1151.run(o, comp);
            }
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while setting NBTData for a TileEntity!", e);
        }
    }

    public static Object getSubNBTTagCompound(Object compound, String name) {
        try {
            if (((Boolean)ReflectionMethod.COMPOUND_HAS_KEY.run(compound, name)).booleanValue()) {
                return ReflectionMethod.COMPOUND_GET_COMPOUND.run(compound, name);
            }
            throw new NbtApiException("Tried getting invalide compound '" + name + "' from '" + compound + "'!");
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting NBT subcompounds!", e);
        }
    }

    public static void addNBTTagCompound(NBTCompound comp, String name) {
        if (name == null) {
            NBTReflectionUtil.remove(comp, name);
            return;
        }
        Object nbttag = comp.getCompound();
        if (nbttag == null) {
            nbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            return;
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(nbttag, comp);
        try {
            ReflectionMethod.COMPOUND_SET.run(workingtag, name, ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance());
            comp.setCompound(nbttag);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while adding a Compound!", e);
        }
    }

    public static Boolean valideCompound(NBTCompound comp) {
        Object root = comp.getCompound();
        if (root == null) {
            root = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        return NBTReflectionUtil.gettoCompount(root, comp) != null;
    }

    protected static Object gettoCompount(Object nbttag, NBTCompound comp) {
        ArrayDeque<String> structure = new ArrayDeque<String>();
        while (comp.getParent() != null) {
            structure.add(comp.getName());
            comp = comp.getParent();
        }
        while (!structure.isEmpty()) {
            String target = (String)structure.pollLast();
            if ((nbttag = NBTReflectionUtil.getSubNBTTagCompound(nbttag, target)) != null) continue;
            throw new NbtApiException("Unable to find tag '" + target + "' in " + nbttag);
        }
        return nbttag;
    }

    public static void mergeOtherNBTCompound(NBTCompound comp, NBTCompound nbtcompoundSrc) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        Object rootnbttagSrc = nbtcompoundSrc.getCompound();
        if (rootnbttagSrc == null) {
            rootnbttagSrc = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nbtcompoundSrc).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtagSrc = NBTReflectionUtil.gettoCompount(rootnbttagSrc, nbtcompoundSrc);
        try {
            ReflectionMethod.COMPOUND_MERGE.run(workingtag, workingtagSrc);
            comp.setCompound(rootnbttag);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while merging two NBTCompounds!", e);
        }
    }

    public static String getContent(NBTCompound comp, String key) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        try {
            return ReflectionMethod.COMPOUND_GET.run(workingtag, key).toString();
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting the Content for key '" + key + "'!", e);
        }
    }

    public static void set(NBTCompound comp, String key, Object val) {
        if (val == null) {
            NBTReflectionUtil.remove(comp, key);
            return;
        }
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        try {
            ReflectionMethod.COMPOUND_SET.run(workingtag, key, val);
            comp.setCompound(rootnbttag);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while setting key '" + key + "' to '" + val + "'!", e);
        }
    }

    public static <T> NBTList<T> getList(NBTCompound comp, String key, NBTType type, Class<T> clazz) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            return null;
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        try {
            Object nbt = ReflectionMethod.COMPOUND_GET_LIST.run(workingtag, key, type.getId());
            if (clazz == String.class) {
                return new NBTStringList(comp, key, type, nbt);
            }
            if (clazz == NBTListCompound.class) {
                return new NBTCompoundList(comp, key, type, nbt);
            }
            if (clazz == Integer.class) {
                return new NBTIntegerList(comp, key, type, nbt);
            }
            if (clazz == Float.class) {
                return new NBTFloatList(comp, key, type, nbt);
            }
            if (clazz == Double.class) {
                return new NBTDoubleList(comp, key, type, nbt);
            }
            if (clazz == Long.class) {
                return new NBTLongList(comp, key, type, nbt);
            }
            return null;
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while getting a list with the type '" + (Object)((Object)type) + "'!", ex);
        }
    }

    public static void setObject(NBTCompound comp, String key, Object value) {
        if (!MinecraftVersion.hasGsonSupport()) {
            return;
        }
        try {
            String json = GsonWrapper.getString(value);
            NBTReflectionUtil.setData(comp, ReflectionMethod.COMPOUND_SET_STRING, key, json);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while setting the Object '" + value + "'!", e);
        }
    }

    public static <T> T getObject(NBTCompound comp, String key, Class<T> type) {
        if (!MinecraftVersion.hasGsonSupport()) {
            return null;
        }
        String json = (String)NBTReflectionUtil.getData(comp, ReflectionMethod.COMPOUND_GET_STRING, key);
        if (json == null) {
            return null;
        }
        return GsonWrapper.deserializeJson(json, type);
    }

    public static void remove(NBTCompound comp, String key) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            return;
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        ReflectionMethod.COMPOUND_REMOVE_KEY.run(workingtag, key);
        comp.setCompound(rootnbttag);
    }

    public static Set<String> getKeys(NBTCompound comp) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        return (Set)ReflectionMethod.COMPOUND_GET_KEYS.run(workingtag, new Object[0]);
    }

    public static void setData(NBTCompound comp, ReflectionMethod type, String key, Object data) {
        if (data == null) {
            NBTReflectionUtil.remove(comp, key);
            return;
        }
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        type.run(workingtag, key, data);
        comp.setCompound(rootnbttag);
    }

    public static Object getData(NBTCompound comp, ReflectionMethod type, String key) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            return null;
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        return type.run(workingtag, key);
    }
}

