/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.bound.objects;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.util.BoundingBox;

public class Bound
implements ConfigurationSerializable {
    private int x;
    private int y;
    private int z;
    private int x2;
    private int y2;
    private int z2;
    private final String world;
    private final String id;

    public Bound(String world, int x, int y, int z, int x2, int y2, int z2, String id) {
        this.world = world;
        this.x = Math.min(x, x2);
        this.y = Math.min(y, y2);
        this.z = Math.min(z, z2);
        this.x2 = Math.max(x, x2);
        this.y2 = Math.max(y, y2);
        this.z2 = Math.max(z, z2);
        this.id = id;
    }

    public Bound(Location location, Location location2, String id) {
        this(Objects.requireNonNull(location.getWorld()).getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), location2.getBlockX(), location2.getBlockY(), location2.getBlockZ(), id);
    }

    public Bound(String string) {
        String[] coords = string.split(":");
        this.world = coords[0];
        this.x = Integer.parseInt(coords[1]);
        this.y = Integer.parseInt(coords[2]);
        this.z = Integer.parseInt(coords[3]);
        this.x2 = Integer.parseInt(coords[4]);
        this.y2 = Integer.parseInt(coords[5]);
        this.z2 = Integer.parseInt(coords[6]);
        this.id = coords[7];
    }

    public boolean isInRegion(Location loc) {
        if (!Objects.requireNonNull(loc.getWorld()).getName().equals(this.world)) {
            return false;
        }
        int cx = loc.getBlockX();
        int cy = loc.getBlockY();
        int cz = loc.getBlockZ();
        return cx >= this.x && cx <= this.x2 && cy >= this.y && cy <= this.y2 && cz >= this.z && cz <= this.z2;
    }

    public List<Location> getBlocks(Material type) {
        World w = Bukkit.getWorld((String)this.world);
        ArrayList<Location> array = new ArrayList<Location>();
        for (int x3 = this.x; x3 <= this.x2; ++x3) {
            for (int y3 = this.y; y3 <= this.y2; ++y3) {
                for (int z3 = this.z; z3 <= this.z2; ++z3) {
                    assert (w != null);
                    Block b = w.getBlockAt(x3, y3, z3);
                    if (b.getType() != type) continue;
                    array.add(b.getLocation());
                }
            }
        }
        return array;
    }

    public List<Block> getBlocks() {
        World w = Bukkit.getWorld((String)this.world);
        ArrayList<Block> array = new ArrayList<Block>();
        for (int x3 = this.x; x3 <= this.x2; ++x3) {
            for (int y3 = this.y; y3 <= this.y2; ++y3) {
                for (int z3 = this.z; z3 <= this.z2; ++z3) {
                    assert (w != null);
                    Block b = w.getBlockAt(x3, y3, z3);
                    array.add(b);
                }
            }
        }
        return array;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world);
    }

    public String getWorldString() {
        return this.world;
    }

    public Location getGreaterCorner() {
        return new Location(Bukkit.getWorld((String)this.world), (double)this.x, (double)this.y, (double)this.z);
    }

    public Location getLesserCorner() {
        return new Location(Bukkit.getWorld((String)this.world), (double)this.x2, (double)this.y2, (double)this.z2);
    }

    public Location getCenter() {
        BoundingBox box = new BoundingBox((double)this.x, (double)this.y, (double)this.z, (double)this.x2, (double)this.y2, (double)this.z2);
        return new Location(this.getWorld(), box.getCenterX(), box.getCenterY(), box.getCenterZ());
    }

    public int getLesserX() {
        return this.x;
    }

    public void setLesserX(int x) {
        this.x = x;
    }

    public int getLesserY() {
        return this.y;
    }

    public void setLesserY(int y) {
        this.y = y;
    }

    public int getLesserZ() {
        return this.z;
    }

    public void setLesserZ(int z) {
        this.z = z;
    }

    public int getGreaterX() {
        return this.x2;
    }

    public void setGreaterX(int x2) {
        this.x2 = x2;
    }

    public int getGreaterY() {
        return this.y2;
    }

    public void setGreaterY(int y2) {
        this.y2 = y2;
    }

    public int getGreaterZ() {
        return this.z2;
    }

    public void setGreaterZ(int z2) {
        this.z2 = z2;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("world", this.world);
        result.put("x1", this.x);
        result.put("y1", this.y);
        result.put("z1", this.z);
        result.put("x2", this.x2);
        result.put("y2", this.y2);
        result.put("z2", this.z2);
        result.put("id", this.id);
        return result;
    }

    public static Bound deserialize(Map<String, Object> args) {
        String world = (String)args.get("world");
        int x = ((Number)args.get("x1")).intValue();
        int y = ((Number)args.get("y1")).intValue();
        int z = ((Number)args.get("z1")).intValue();
        int x2 = ((Number)args.get("x2")).intValue();
        int y2 = ((Number)args.get("y2")).intValue();
        int z2 = ((Number)args.get("z2")).intValue();
        String id = String.valueOf(args.get("id"));
        return new Bound(world, x, y, z, x2, y2, z2, id);
    }
}

