/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

public class ItemBuilder {
    final ItemStack itemStack;
    final ItemMeta itemMeta;

    public ItemBuilder(@NotNull Material material) {
        this(material, 1);
    }

    public ItemBuilder(@NotNull Material material, int amount) {
        this.itemStack = new ItemStack(material, amount);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(@NotNull Material material, @NotNull Consumer<ItemMeta> meta) {
        this(material, 1, meta);
    }

    public ItemBuilder(@NotNull Material material, int amount, @NotNull Consumer<ItemMeta> meta) {
        this.itemStack = new ItemStack(material, amount);
        this.itemMeta = this.itemStack.getItemMeta();
        meta.accept(this.itemMeta);
    }

    public ItemBuilder name(@NotNull String name) {
        this.itemMeta.setDisplayName(Util.getColString(name));
        return this;
    }

    public ItemBuilder addLore(@NotNull String lore) {
        ArrayList<String> lores = this.itemMeta.getLore();
        if (lores == null) {
            lores = new ArrayList<String>();
        }
        lores.add(Util.getColString(lore));
        this.itemMeta.setLore(lores);
        return this;
    }

    public ItemBuilder lore(@NotNull List<String> lores) {
        this.itemMeta.setLore(lores);
        return this;
    }

    public ItemBuilder addEnchant(@NotNull Enchantment enchantment, int level) {
        this.itemMeta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder hideEnchants() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return this;
    }

    public ItemBuilder hideAttributes() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        return this;
    }

    public ItemBuilder hideUnbreakable() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        return this;
    }

    public ItemBuilder hidePotionEffects() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        return this;
    }

    public ItemBuilder customModelData(int modelData) {
        this.itemMeta.setCustomModelData(Integer.valueOf(modelData));
        return this;
    }

    public ItemBuilder unbreakable() {
        this.itemMeta.setUnbreakable(true);
        return this;
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }
}

