/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.util;

import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.elements.recipe.util.Remover;

public class RecipeUtil {
    private static final Remover REMOVER = new Remover();
    private static final String NAMESPACE = SkBee.getPlugin().getPluginConfig().RECIPE_NAMESPACE;

    public static NamespacedKey getKey(String key) {
        return new NamespacedKey(NAMESPACE, key.toLowerCase());
    }

    private static NamespacedKey getKeyByPlugin(String key) {
        if (key.contains(":")) {
            String[] split = key.split(":");
            return new NamespacedKey(split[0], split[1]);
        }
        return null;
    }

    public static void removeRecipe(String recipe) {
        if ((recipe = recipe.toLowerCase()).contains("minecraft:")) {
            RecipeUtil.removeMCRecipe(recipe);
        } else if (recipe.contains(NAMESPACE + ":")) {
            recipe = recipe.split(":")[1];
            REMOVER.removeRecipeByKey(RecipeUtil.getKey(recipe));
        } else if (recipe.contains(":")) {
            NamespacedKey key = RecipeUtil.getKeyByPlugin(recipe);
            if (key != null) {
                REMOVER.removeRecipeByKey(key);
            }
        } else {
            REMOVER.removeRecipeByKey(RecipeUtil.getKey(recipe));
        }
    }

    public static void removeRecipe(NamespacedKey key) {
        REMOVER.removeRecipeByKey(key);
    }

    public static void removeMCRecipe(String recipe) {
        recipe = recipe.replace("minecraft:", "");
        REMOVER.removeRecipeByKey(NamespacedKey.minecraft((String)recipe));
    }

    public static void removeAllMCRecipes() {
        REMOVER.removeAll();
    }

    public static void logRecipe(Recipe recipe, String ingredients) {
        RecipeUtil.log("&aRegistered new recipe:");
        RecipeUtil.log(" - &7Result: " + recipe.getResult());
        RecipeUtil.log(" - &7Ingredients: " + ingredients);
    }

    public static void error(String error) {
        RecipeUtil.log("&c" + error);
    }

    public static void warn(String warning) {
        RecipeUtil.log("&e" + warning);
    }

    public static void log(String log) {
        String prefix = "&7[&bRecipe&7] ";
        SkBee.log(prefix + log);
    }
}

