/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="Stored Enchantments")
@Description(value={"Get/set the stored enchantments of an enchanted book."})
@Examples(value={"set {_a::*} to stored enchants of player's tool", "set stored enchants of player's tool to sharpness 3 and unbreaking 2", "add sharpness 1 to stored enchants of player's tool", "delete stored enchants of player's tool", "remove sharpness from stored enchants of player's tool"})
@Since(value="1.0.0")
public class ExprStoredEnchant
extends SimpleExpression<EnchantmentType> {
    private Expression<ItemType> itemTypes;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.itemTypes = exprs[0];
        return true;
    }

    protected EnchantmentType[] get(Event event) {
        ArrayList<EnchantmentType> enchants = new ArrayList<EnchantmentType>();
        for (ItemType item : (ItemType[])this.itemTypes.getAll(event)) {
            ItemMeta meta = item.getItemMeta();
            if (!(meta instanceof EnchantmentStorageMeta)) continue;
            Map stored = ((EnchantmentStorageMeta)meta).getStoredEnchants();
            for (Enchantment ench : stored.keySet()) {
                enchants.add(new EnchantmentType(ench, ((Integer)stored.get(ench)).intValue()));
            }
        }
        return enchants.toArray(new EnchantmentType[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: 
            case DELETE: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Enchantment[].class, EnchantmentType[].class});
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EnchantmentType[] enchants = new EnchantmentType[delta != null ? delta.length : 0];
        if (delta != null && delta.length != 0) {
            for (int i = 0; i < delta.length; ++i) {
                enchants[i] = delta[i] instanceof EnchantmentType ? (EnchantmentType)delta[i] : new EnchantmentType((Enchantment)delta[i]);
            }
        }
        block7: for (ItemType item : (ItemType[])this.itemTypes.getAll(e)) {
            ItemMeta meta = item.getItemMeta();
            if (!(meta instanceof EnchantmentStorageMeta)) {
                return;
            }
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            switch (mode) {
                case SET: {
                    for (Enchantment ench : storageMeta.getStoredEnchants().keySet()) {
                        storageMeta.removeStoredEnchant(ench);
                    }
                }
                case ADD: {
                    for (EnchantmentType enchantmentType : enchants) {
                        if (enchantmentType.getType() == null) continue;
                        storageMeta.addStoredEnchant(enchantmentType.getType(), enchantmentType.getLevel(), true);
                    }
                    item.setItemMeta((ItemMeta)storageMeta);
                    continue block7;
                }
                case REMOVE: {
                    for (EnchantmentType enchantmentType : enchants) {
                        if (enchantmentType.getType() == null) continue;
                        storageMeta.removeStoredEnchant(enchantmentType.getType());
                    }
                    item.setItemMeta((ItemMeta)storageMeta);
                    continue block7;
                }
                case DELETE: {
                    for (Enchantment ench : storageMeta.getStoredEnchants().keySet()) {
                        storageMeta.removeStoredEnchant(ench);
                    }
                    item.setItemMeta((ItemMeta)storageMeta);
                    continue block7;
                }
                default: {
                    return;
                }
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends EnchantmentType> getReturnType() {
        return EnchantmentType.class;
    }

    public String toString(Event e, boolean d) {
        return "stored enchantments of " + this.itemTypes.toString(e, d);
    }

    static {
        PropertyExpression.register(ExprStoredEnchant.class, EnchantmentType.class, (String)"stored enchant[ment]s", (String)"itemtypes");
    }
}

