/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBTApi;

@Name(value="NBT - Set Block with NBT")
@Description(value={"Set a block at a location to a block with NBT"})
@Examples(value={"set nbt-block at player to west facing furnace with nbt \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&aFurnieFurnace\\\"\"}\"\"}\"", "set nbt-block at event-location to hopper with nbt \"{CustomName:\"\"{\\\"\"text\\\"\":\\\"\"&cHoppieHopper\\\"\"}\"\"}\""})
@Since(value="1.0.0")
public class EffSetBlockNBT
extends Effect {
    private static final NBTApi NBT_API;
    private Expression<Location> locations;
    private Expression<ItemType> type;
    private Expression<String> nbtString;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.type = exprs[2];
        this.locations = Direction.combine(exprs[0], exprs[1]);
        this.nbtString = exprs[3];
        return NBT_API.validateNBT(this.nbtString);
    }

    public void execute(Event e) {
        String value = (String)this.nbtString.getSingle(e);
        ItemType block = (ItemType)this.type.getSingle(e);
        for (Location loc : (Location[])this.locations.getArray(e)) {
            assert (loc != null) : this.locations;
            block.getBlock().setBlock(loc.getBlock(), true);
            NBT_API.addNBT(loc.getBlock(), value);
        }
    }

    public String toString(Event e, boolean debug) {
        return "set block " + this.locations.toString(e, debug) + " to " + this.type.toString(e, debug) + " with nbt " + this.nbtString.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetBlockNBT.class, (String[])new String[]{"set (nbt[(-| )]block|tile[(-| )]entity) %directions% %locations% to %itemtype% with nbt %string%"});
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

