/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.NBT;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTType;
import tk.shanebee.bee.api.NBT.NbtApiException;
import tk.shanebee.bee.api.NBT.utils.MinecraftVersion;
import tk.shanebee.bee.api.NBT.utils.nmsmappings.ReflectionMethod;

public abstract class NBTList<T>
implements List<T> {
    private String listName;
    private NBTCompound parent;
    private NBTType type;
    protected Object listObject;

    protected NBTList(NBTCompound owner, String name, NBTType type, Object list) {
        this.parent = owner;
        this.listName = name;
        this.type = type;
        this.listObject = list;
    }

    public String getName() {
        return this.listName;
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    protected void save() {
        this.parent.set(this.listName, this.listObject);
    }

    protected abstract Object asTag(T var1);

    @Override
    public boolean add(T element) {
        try {
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, this.size(), this.asTag(element));
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, this.asTag(element));
            }
            this.save();
            return true;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public void add(int index, T element) {
        try {
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, index, this.asTag(element));
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, this.asTag(element));
            }
            this.save();
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public T set(int index, T element) {
        try {
            Object prev = this.get(index);
            ReflectionMethod.LIST_SET.run(this.listObject, index, this.asTag(element));
            this.save();
            return (T)prev;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public T remove(int i) {
        try {
            Object old = this.get(i);
            ReflectionMethod.LIST_REMOVE_KEY.run(this.listObject, i);
            this.save();
            return (T)old;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public int size() {
        try {
            return (Integer)ReflectionMethod.LIST_SIZE.run(this.listObject, new Object[0]);
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    public NBTType getType() {
        return this.type;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.remove(0);
        }
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int size = this.size();
        for (T ele : c) {
            this.add(ele);
        }
        return size != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int size = this.size();
        for (T ele : c) {
            this.add(index++, ele);
        }
        return size != this.size();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object ele : c) {
            if (this.contains(ele)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            index = i;
        }
        return index;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int size = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return size != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int size = this.size();
        for (Object obj : c) {
            for (int i = 0; i < this.size(); ++i) {
                if (obj.equals(this.get(i))) continue;
                this.remove(i--);
            }
        }
        return size != this.size();
    }

    @Override
    public boolean remove(Object o) {
        int size = this.size();
        int id = -1;
        while ((id = this.indexOf(o)) != -1) {
            this.remove(id);
        }
        return size != this.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return NBTList.this.size() > this.index + 1;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return NBTList.this.get(++this.index);
            }
        };
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int startIndex) {
        final NBTList list = this;
        return new ListIterator<T>(){
            int index;
            {
                this.index = startIndex - 1;
            }

            @Override
            public void add(T e) {
                list.add(this.index, e);
            }

            @Override
            public boolean hasNext() {
                return NBTList.this.size() > this.index + 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index >= 0 && this.index <= NBTList.this.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return NBTList.this.get(++this.index);
            }

            @Override
            public int nextIndex() {
                return this.index + 1;
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("Id: " + (this.index - 1));
                }
                return NBTList.this.get(this.index--);
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                list.remove(this.index);
            }

            @Override
            public void set(T e) {
                list.set(this.index, e);
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] ar = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ar[i] = this.get(i);
        }
        return ar;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        Object[] ar = Arrays.copyOf(a, this.size());
        Arrays.fill(ar, null);
        Class<?> arrayclass = a.getClass().getComponentType();
        for (int i = 0; i < this.size(); ++i) {
            Object obj = this.get(i);
            if (!arrayclass.isInstance(obj)) {
                throw new ArrayStoreException("The array does not match the objects stored in the List.");
            }
            ar[i] = this.get(i);
        }
        return ar;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ArrayList list = new ArrayList();
        for (int i = fromIndex; i < toIndex; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public String toString() {
        return this.listObject.toString();
    }
}

