/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBTApi;

@Name(value="NBT - Item with NBT")
@Description(value={"Give players items with NBT or even use items with NBT in GUIs"})
@Examples(value={"give player diamond sword with nbt \"{Unbreakable:1}\"", "format gui slot 1 of player with diamond axe with nbt \"{Enchantments:[{id:\\\"\\\"unbreaking\\\"\\\",lvl:5s}]}\""})
@Since(value="1.0.0")
public class ExprItemWithNBT
extends PropertyExpression<ItemType, ItemType> {
    private static final NBTApi NBT_API;
    private Expression<String> nbt;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.nbt = exprs[1];
        return NBT_API.validateNBT(this.nbt);
    }

    protected ItemType[] get(Event e, ItemType[] source) {
        String nbt = (String)this.nbt.getSingle(e);
        return (ItemType[])this.get(source, item -> {
            NBT_API.addNBT((ItemType)item, nbt);
            return item;
        });
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.getExpr().toString(e, debug) + " with nbt " + this.nbt.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprItemWithNBT.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"%itemtype% with [item( |-)]nbt %string%"});
        NBT_API = SkBee.getPlugin().getNbtApi();
    }
}

