/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import tk.shanebee.bee.api.virtualfurnace.api.recipe.Recipe;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

public class FurnaceRecipe
extends Recipe {
    private static final boolean HAS_SMOKING = Util.isRunningMinecraft(1, 14);
    private static final List<FurnaceRecipe> VANILLA_FURNACE_RECIPES = new ArrayList<FurnaceRecipe>();
    private static final List<FurnaceRecipe> VANILLA_SMOKING_RECIPES = new ArrayList<FurnaceRecipe>();
    private static final List<FurnaceRecipe> VANILLA_BLASTING_RECIPES = new ArrayList<FurnaceRecipe>();
    private final Material ingredient;
    private final int cookTime;

    public static List<FurnaceRecipe> getVanillaFurnaceRecipes() {
        return VANILLA_FURNACE_RECIPES;
    }

    public static List<FurnaceRecipe> getVanillaSmokingRecipes() {
        return VANILLA_SMOKING_RECIPES;
    }

    public static List<FurnaceRecipe> getVanillaBlastingRecipes() {
        return VANILLA_BLASTING_RECIPES;
    }

    public FurnaceRecipe(NamespacedKey key, Material ingredient, Material result, int cookTime) {
        super(key, result);
        this.ingredient = ingredient;
        this.cookTime = cookTime;
    }

    public Material getIngredient() {
        return this.ingredient;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FurnaceRecipe that = (FurnaceRecipe)o;
        return this.cookTime == that.cookTime && this.ingredient == that.ingredient;
    }

    public int hashCode() {
        return Objects.hash(this.ingredient, this.cookTime);
    }

    public String toString() {
        return "FurnaceRecipe{key=" + this.key + ", ingredient=" + this.ingredient + ", result=" + this.result + ", cookTime=" + this.cookTime + '}';
    }

    static {
        Bukkit.recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof org.bukkit.inventory.FurnaceRecipe) {
                org.bukkit.inventory.FurnaceRecipe r = (org.bukkit.inventory.FurnaceRecipe)recipe;
                FurnaceRecipe rec = new FurnaceRecipe(Util.getKey("mc_furnace_" + r.getKey().getKey()), r.getInput().getType(), r.getResult().getType(), r.getCookingTime());
                VANILLA_FURNACE_RECIPES.add(rec);
            } else if (HAS_SMOKING) {
                if (recipe instanceof SmokingRecipe) {
                    SmokingRecipe r = (SmokingRecipe)recipe;
                    FurnaceRecipe rec = new FurnaceRecipe(Util.getKey("mc_smoking_" + r.getKey().getKey()), r.getInput().getType(), r.getResult().getType(), r.getCookingTime());
                    VANILLA_SMOKING_RECIPES.add(rec);
                } else if (recipe instanceof BlastingRecipe) {
                    BlastingRecipe r = (BlastingRecipe)recipe;
                    FurnaceRecipe rec = new FurnaceRecipe(Util.getKey("mc_blasting_" + r.getKey().getKey()), r.getInput().getType(), r.getResult().getType(), r.getCookingTime());
                    VANILLA_BLASTING_RECIPES.add(rec);
                }
            }
        });
    }
}

