/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.api.virtualfurnace.api.machine.Furnace;
import tk.shanebee.bee.api.virtualfurnace.api.property.FurnaceProperties;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

public class FurnaceManager {
    private final VirtualFurnaceAPI virtualFurnaceAPI;
    private File furnaceFile;
    private FileConfiguration furnaceConfig;
    private final Map<UUID, Furnace> furnaceMap;
    private final NamespacedKey key;

    FurnaceManager(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.virtualFurnaceAPI = virtualFurnaceAPI;
        this.furnaceMap = new HashMap<UUID, Furnace>();
        this.key = new NamespacedKey((Plugin)virtualFurnaceAPI.getJavaPlugin(), "furnaceID");
        this.loadFurnaceConfig();
    }

    public Collection<Furnace> getAllFurnaces() {
        return Collections.unmodifiableCollection(this.furnaceMap.values());
    }

    public Furnace getByID(@NotNull UUID uuid) {
        return this.furnaceMap.get(uuid);
    }

    public Furnace createFurnace(@NotNull String name) {
        return this.createFurnace(name, FurnaceProperties.FURNACE, null);
    }

    public Furnace createFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties) {
        return this.createFurnace(name, furnaceProperties, null);
    }

    public Furnace createFurnace(@NotNull String name, @NotNull Consumer<Furnace> function) {
        return this.createFurnace(name, FurnaceProperties.FURNACE, function);
    }

    public Furnace createFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @Nullable Consumer<Furnace> function) {
        Furnace furnace = new Furnace(name, furnaceProperties);
        if (function != null) {
            function.accept(furnace);
        }
        this.furnaceMap.put(furnace.getUniqueID(), furnace);
        this.saveFurnace(furnace, true);
        return furnace;
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull Material material, boolean glowing) {
        return this.createItemWithFurnace(name, new ItemStack(material), glowing);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull Material material, boolean glowing) {
        return this.createItemWithFurnace(name, furnaceProperties, new ItemStack(material), glowing);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull Material material, boolean glowing, @Nullable Consumer<Furnace> function) {
        return this.createItemWithFurnace(name, new ItemStack(material), glowing, function);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull Material material, boolean glowing, @Nullable Consumer<Furnace> function) {
        return this.createItemWithFurnace(name, furnaceProperties, new ItemStack(material), glowing, function);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull ItemStack itemStack, boolean glowing) {
        return this.createItemWithFurnace(name, itemStack, glowing, null);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull ItemStack itemStack, boolean glowing) {
        return this.createItemWithFurnace(name, furnaceProperties, itemStack, glowing, null);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull ItemStack itemStack, boolean glowing, @Nullable Consumer<Furnace> function) {
        return this.createItemWithFurnace(name, FurnaceProperties.FURNACE, itemStack, glowing, function);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull ItemStack itemStack, boolean glowing, @Nullable Consumer<Furnace> function) {
        ItemStack item = itemStack.clone();
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (glowing) {
            if (item.getType() == Material.ARROW) {
                meta.addEnchant(Enchantment.DAMAGE_ALL, 1, true);
            } else {
                meta.addEnchant(Enchantment.ARROW_INFINITE, 1, true);
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        Furnace furnace = function == null ? this.createFurnace(name, furnaceProperties) : this.createFurnace(name, furnaceProperties, function);
        meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)furnace.getUniqueID().toString());
        item.setItemMeta(meta);
        return item;
    }

    public Furnace getFurnaceFromItemStack(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        assert (meta != null);
        if (meta.getPersistentDataContainer().has(this.key, PersistentDataType.STRING)) {
            String u = (String)meta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
            if (u == null) {
                return null;
            }
            return this.getByID(UUID.fromString(u));
        }
        return null;
    }

    private void loadFurnaceConfig() {
        if (this.furnaceFile == null) {
            this.furnaceFile = new File(this.virtualFurnaceAPI.getJavaPlugin().getDataFolder(), "furnaces.yml");
        }
        if (!this.furnaceFile.exists()) {
            this.virtualFurnaceAPI.getJavaPlugin().saveResource("furnaces.yml", false);
        }
        this.furnaceConfig = YamlConfiguration.loadConfiguration((File)this.furnaceFile);
        this.loadFurnaces();
    }

    void loadFurnaces() {
        ConfigurationSection section = this.furnaceConfig.getConfigurationSection("furnaces");
        if (section != null) {
            for (String string : section.getKeys(true)) {
                if (!(section.get(string) instanceof Furnace)) continue;
                Furnace furnace = (Furnace)section.get(string);
                this.furnaceMap.put(UUID.fromString(string), (Furnace)section.get(string));
            }
        }
        Util.log("Loaded: &b" + this.furnaceMap.size() + "&7 furnaces");
    }

    public void saveFurnace(@NotNull Furnace furnace, boolean saveToFile) {
        this.furnaceConfig.set("furnaces." + furnace.getUniqueID(), (Object)furnace);
        if (saveToFile) {
            this.saveConfig();
        }
    }

    public void removeFurnaceFromConfig(@NotNull Furnace furnace, boolean saveToFile) {
        this.furnaceConfig.set("furnaces." + furnace.getUniqueID(), null);
        if (saveToFile) {
            this.saveConfig();
        }
    }

    public void saveAll() {
        for (Furnace furnace : this.furnaceMap.values()) {
            this.saveFurnace(furnace, false);
        }
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            this.furnaceConfig.save(this.furnaceFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void shutdown() {
        this.saveAll();
        this.furnaceMap.clear();
    }
}

