/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api;

import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import tk.shanebee.bee.api.virtualfurnace.api.FurnaceManager;
import tk.shanebee.bee.api.virtualfurnace.api.TileManager;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.api.virtualfurnace.api.chunk.VirtualChunk;
import tk.shanebee.bee.api.virtualfurnace.api.machine.Furnace;
import tk.shanebee.bee.api.virtualfurnace.api.tile.Tile;

class FurnaceListener
implements Listener {
    private final FurnaceManager furnaceManager;
    private final TileManager tileManager;

    FurnaceListener(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.furnaceManager = virtualFurnaceAPI.getFurnaceManager();
        this.tileManager = virtualFurnaceAPI.getTileManager();
    }

    @EventHandler
    private void onClickFurnace(PlayerInteractEvent event) {
        Tile<?> tile;
        Furnace furnace;
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack hand = event.getItem();
        if (hand != null && (furnace = this.furnaceManager.getFurnaceFromItemStack(hand)) != null) {
            event.setCancelled(true);
            furnace.openInventory(event.getPlayer());
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Chunk chunk = block.getChunk();
        VirtualChunk virtualChunk = this.tileManager.getChunk(chunk);
        if (virtualChunk != null && (tile = virtualChunk.getTile(block)) != null) {
            tile.activate(event.getPlayer());
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onChunkLoad(ChunkLoadEvent event) {
        this.handleChunk(event.getChunk(), true);
    }

    @EventHandler
    private void onChunkUnload(ChunkUnloadEvent event) {
        this.handleChunk(event.getChunk(), false);
    }

    private void handleChunk(Chunk chunk, boolean load) {
        VirtualChunk virtualChunk = this.tileManager.getChunk(chunk);
        if (virtualChunk != null) {
            if (load) {
                if (virtualChunk.isLoaded()) {
                    return;
                }
                this.tileManager.loadChunk(virtualChunk);
            } else {
                if (virtualChunk.isForceLoaded()) {
                    return;
                }
                this.tileManager.unloadChunk(virtualChunk);
            }
        }
    }
}

