/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.NBT;

import org.bukkit.entity.Entity;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTReflectionUtil;
import tk.shanebee.bee.api.NBT.utils.MinecraftVersion;
import tk.shanebee.bee.api.NBT.utils.annotations.AvaliableSince;
import tk.shanebee.bee.api.NBT.utils.annotations.CheckUtil;
import tk.shanebee.bee.api.NBT.utils.annotations.FAUtil;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null || entity.isDead()) {
            throw new NullPointerException("Entity can't be null/dead!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object compound) {
        NBTReflectionUtil.setEntityNBTTag(compound, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @AvaliableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("BukkitValues").booleanValue()) {
            return this.getCompound("BukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("BukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("BukkitValues");
    }
}

