/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.structure.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import tk.shanebee.bee.api.Structure.bukkit.api.StructureBlockApi;
import tk.shanebee.bee.api.Structure.bukkit.api.business.enumeration.StructureMirror;
import tk.shanebee.bee.api.Structure.bukkit.api.business.enumeration.StructureRotation;
import tk.shanebee.bee.api.Structure.bukkit.api.business.service.PersistenceStructureService;
import tk.shanebee.bee.api.Structure.bukkit.api.persistence.entity.StructureSaveConfiguration;

@Name(value="Structure Block - Load")
@Description(value={"Load structure block structures that are saved on your server. Optional values for rotation, mirroring and the inclusion of entities. 1.9.4+ ONLY"})
@Examples(value={"load \"house\" at location of player", "load \"barn\" at location 10 infront of player", "paste \"house\" at location of player with rotation 90 and with mirror left to right", "load \"sheep_pen\" at location below player with rotation 180 and with entities"})
@Since(value="1.0.0")
public class EffLoadStructure
extends Effect {
    private Expression<String> name;
    private Expression<Location> loc;
    private int rotate = 0;
    private int mirror;
    private boolean withEntities;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.loc = exprs[1];
        this.rotate = parseResult.mark;
        this.mirror = i;
        this.withEntities = this.rotate == 5 || this.rotate == 4 || this.rotate == 7 || this.rotate == 6;
        return true;
    }

    protected void execute(Event event) {
        PersistenceStructureService service = StructureBlockApi.INSTANCE.getStructurePersistenceService();
        String world = ((World)Bukkit.getServer().getWorlds().get(0)).getName();
        StructureSaveConfiguration saveConfig = service.createSaveConfiguration("minecraft", (String)this.name.getSingle(event), world);
        switch (this.rotate) {
            case 0: 
            case 5: {
                saveConfig.setRotation(StructureRotation.NONE);
                break;
            }
            case 1: 
            case 4: {
                saveConfig.setRotation(StructureRotation.ROTATION_90);
                break;
            }
            case 2: 
            case 7: {
                saveConfig.setRotation(StructureRotation.ROTATION_180);
                break;
            }
            case 3: 
            case 6: {
                saveConfig.setRotation(StructureRotation.ROTATION_270);
            }
        }
        switch (this.mirror) {
            case 0: {
                saveConfig.setMirror(StructureMirror.NONE);
                break;
            }
            case 1: {
                saveConfig.setMirror(StructureMirror.FRONT_BACK);
                break;
            }
            case 2: {
                saveConfig.setMirror(StructureMirror.LEFT_RIGHT);
            }
        }
        saveConfig.setIgnoreEntities(!this.withEntities);
        boolean structureExists = service.load(saveConfig, (Location)this.loc.getSingle(event));
        if (!structureExists) {
            Skript.error((String)("Structure " + this.name.toString(event, true) + " does not exist!"));
        }
    }

    public String toString(Event e, boolean d) {
        return "load structure " + this.name.toString(e, d) + " at " + this.loc.toString(e, d);
    }

    static {
        Skript.registerEffect(EffLoadStructure.class, (String[])new String[]{"(load|paste) [structure] %string% at %location% [with rotation (0\u00a60|1\u00a690|2\u00a6180|3\u00a6270)] [(|5\u00a6[and] with entities)]", "(load|paste) [structure] %string% at %location% [with rotation (0\u00a60|1\u00a690|2\u00a6180|3\u00a6270)] [and] [with] mirror front to back [(|5\u00a6[and] with entities)]", "(load|paste) [structure] %string% at %location% [with rotation (0\u00a60|1\u00a690|2\u00a6180|3\u00a6270)] [and] [with] mirror left to right [(|5\u00a6[and] with entities)]"});
    }
}

